/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.SchemasSAMLConnection;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class CreateSAMLConnectionResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SchemasSAMLConnection> schemasSAMLConnection;

    @JsonCreator
    public CreateSAMLConnectionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SchemasSAMLConnection> schemasSAMLConnection) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.schemasSAMLConnection = schemasSAMLConnection;
    }

    public CreateSAMLConnectionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SchemasSAMLConnection> schemasSAMLConnection() {
        return this.schemasSAMLConnection;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateSAMLConnectionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateSAMLConnectionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateSAMLConnectionResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateSAMLConnectionResponse withSchemasSAMLConnection(SchemasSAMLConnection schemasSAMLConnection) {
        Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
        this.schemasSAMLConnection = Optional.ofNullable(schemasSAMLConnection);
        return this;
    }

    public CreateSAMLConnectionResponse withSchemasSAMLConnection(Optional<? extends SchemasSAMLConnection> schemasSAMLConnection) {
        Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
        this.schemasSAMLConnection = schemasSAMLConnection;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSAMLConnectionResponse other = (CreateSAMLConnectionResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.schemasSAMLConnection, other.schemasSAMLConnection);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.schemasSAMLConnection);
    }

    public String toString() {
        return Utils.toString(CreateSAMLConnectionResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "schemasSAMLConnection", this.schemasSAMLConnection);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SchemasSAMLConnection> schemasSAMLConnection = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder schemasSAMLConnection(SchemasSAMLConnection schemasSAMLConnection) {
            Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
            this.schemasSAMLConnection = Optional.ofNullable(schemasSAMLConnection);
            return this;
        }

        public Builder schemasSAMLConnection(Optional<? extends SchemasSAMLConnection> schemasSAMLConnection) {
            Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
            this.schemasSAMLConnection = schemasSAMLConnection;
            return this;
        }

        public CreateSAMLConnectionResponse build() {
            return new CreateSAMLConnectionResponse(this.contentType, this.statusCode, this.rawResponse, this.schemasSAMLConnection);
        }
    }
}

