/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class CreateSessionTokenFromTemplateResponseBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="object")
    private Optional<? extends CreateSessionTokenFromTemplateObject> object;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="jwt")
    private Optional<String> jwt;

    @JsonCreator
    public CreateSessionTokenFromTemplateResponseBody(@JsonProperty(value="object") Optional<? extends CreateSessionTokenFromTemplateObject> object, @JsonProperty(value="jwt") Optional<String> jwt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(jwt, "jwt");
        this.object = object;
        this.jwt = jwt;
    }

    public CreateSessionTokenFromTemplateResponseBody() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<CreateSessionTokenFromTemplateObject> object() {
        return this.object;
    }

    @JsonIgnore
    public Optional<String> jwt() {
        return this.jwt;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateSessionTokenFromTemplateResponseBody withObject(CreateSessionTokenFromTemplateObject object) {
        Utils.checkNotNull(object, "object");
        this.object = Optional.ofNullable(object);
        return this;
    }

    public CreateSessionTokenFromTemplateResponseBody withObject(Optional<? extends CreateSessionTokenFromTemplateObject> object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public CreateSessionTokenFromTemplateResponseBody withJwt(String jwt) {
        Utils.checkNotNull(jwt, "jwt");
        this.jwt = Optional.ofNullable(jwt);
        return this;
    }

    public CreateSessionTokenFromTemplateResponseBody withJwt(Optional<String> jwt) {
        Utils.checkNotNull(jwt, "jwt");
        this.jwt = jwt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSessionTokenFromTemplateResponseBody other = (CreateSessionTokenFromTemplateResponseBody)o;
        return Objects.deepEquals(this.object, other.object) && Objects.deepEquals(this.jwt, other.jwt);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.jwt);
    }

    public String toString() {
        return Utils.toString(CreateSessionTokenFromTemplateResponseBody.class, "object", this.object, "jwt", this.jwt);
    }

    public static final class Builder {
        private Optional<? extends CreateSessionTokenFromTemplateObject> object = Optional.empty();
        private Optional<String> jwt = Optional.empty();

        private Builder() {
        }

        public Builder object(CreateSessionTokenFromTemplateObject object) {
            Utils.checkNotNull(object, "object");
            this.object = Optional.ofNullable(object);
            return this;
        }

        public Builder object(Optional<? extends CreateSessionTokenFromTemplateObject> object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder jwt(String jwt) {
            Utils.checkNotNull(jwt, "jwt");
            this.jwt = Optional.ofNullable(jwt);
            return this;
        }

        public Builder jwt(Optional<String> jwt) {
            Utils.checkNotNull(jwt, "jwt");
            this.jwt = jwt;
            return this;
        }

        public CreateSessionTokenFromTemplateResponseBody build() {
            return new CreateSessionTokenFromTemplateResponseBody(this.object, this.jwt);
        }
    }
}

