/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateSignInTokenRequestBody {
    @JsonProperty(value="user_id")
    private String userId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="expires_in_seconds")
    private JsonNullable<Long> expiresInSeconds;

    @JsonCreator
    public CreateSignInTokenRequestBody(@JsonProperty(value="user_id") String userId, @JsonProperty(value="expires_in_seconds") JsonNullable<Long> expiresInSeconds) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
        this.userId = userId;
        this.expiresInSeconds = expiresInSeconds;
    }

    public CreateSignInTokenRequestBody(String userId) {
        this(userId, (JsonNullable<Long>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public JsonNullable<Long> expiresInSeconds() {
        return this.expiresInSeconds;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public CreateSignInTokenRequestBody withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public CreateSignInTokenRequestBody withExpiresInSeconds(long expiresInSeconds) {
        Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
        this.expiresInSeconds = JsonNullable.of((Object)expiresInSeconds);
        return this;
    }

    public CreateSignInTokenRequestBody withExpiresInSeconds(JsonNullable<Long> expiresInSeconds) {
        Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
        this.expiresInSeconds = expiresInSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSignInTokenRequestBody other = (CreateSignInTokenRequestBody)o;
        return Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.expiresInSeconds, other.expiresInSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.expiresInSeconds);
    }

    public String toString() {
        return Utils.toString(CreateSignInTokenRequestBody.class, "userId", this.userId, "expiresInSeconds", this.expiresInSeconds);
    }

    public static final class Builder {
        private String userId;
        private JsonNullable<Long> expiresInSeconds;
        private static final LazySingletonValue<JsonNullable<Long>> _SINGLETON_VALUE_ExpiresInSeconds = new LazySingletonValue<JsonNullable<Long>>("expires_in_seconds", "2592000", new TypeReference<JsonNullable<Long>>(){});

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder expiresInSeconds(long expiresInSeconds) {
            Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
            this.expiresInSeconds = JsonNullable.of((Object)expiresInSeconds);
            return this;
        }

        public Builder expiresInSeconds(JsonNullable<Long> expiresInSeconds) {
            Utils.checkNotNull(expiresInSeconds, "expiresInSeconds");
            this.expiresInSeconds = expiresInSeconds;
            return this;
        }

        public CreateSignInTokenRequestBody build() {
            if (this.expiresInSeconds == null) {
                this.expiresInSeconds = _SINGLETON_VALUE_ExpiresInSeconds.value();
            }
            return new CreateSignInTokenRequestBody(this.userId, this.expiresInSeconds);
        }
    }
}

