/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class DeleteOrganizationLogoRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;

    @JsonCreator
    public DeleteOrganizationLogoRequest(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public DeleteOrganizationLogoRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOrganizationLogoRequest other = (DeleteOrganizationLogoRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId);
    }

    public String toString() {
        return Utils.toString(DeleteOrganizationLogoRequest.class, "organizationId", this.organizationId);
    }

    public static final class Builder {
        private String organizationId;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public DeleteOrganizationLogoRequest build() {
            return new DeleteOrganizationLogoRequest(this.organizationId);
        }
    }
}

