/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.SvixURL;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GenerateSvixAuthURLResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SvixURL> svixURL;

    @JsonCreator
    public GenerateSvixAuthURLResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SvixURL> svixURL) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(svixURL, "svixURL");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.svixURL = svixURL;
    }

    public GenerateSvixAuthURLResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SvixURL> svixURL() {
        return this.svixURL;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GenerateSvixAuthURLResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GenerateSvixAuthURLResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GenerateSvixAuthURLResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GenerateSvixAuthURLResponse withSvixURL(SvixURL svixURL) {
        Utils.checkNotNull(svixURL, "svixURL");
        this.svixURL = Optional.ofNullable(svixURL);
        return this;
    }

    public GenerateSvixAuthURLResponse withSvixURL(Optional<? extends SvixURL> svixURL) {
        Utils.checkNotNull(svixURL, "svixURL");
        this.svixURL = svixURL;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateSvixAuthURLResponse other = (GenerateSvixAuthURLResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.svixURL, other.svixURL);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.svixURL);
    }

    public String toString() {
        return Utils.toString(GenerateSvixAuthURLResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "svixURL", this.svixURL);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SvixURL> svixURL = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder svixURL(SvixURL svixURL) {
            Utils.checkNotNull(svixURL, "svixURL");
            this.svixURL = Optional.ofNullable(svixURL);
            return this;
        }

        public Builder svixURL(Optional<? extends SvixURL> svixURL) {
            Utils.checkNotNull(svixURL, "svixURL");
            this.svixURL = svixURL;
            return this;
        }

        public GenerateSvixAuthURLResponse build() {
            return new GenerateSvixAuthURLResponse(this.contentType, this.statusCode, this.rawResponse, this.svixURL);
        }
    }
}

