/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class GetJWTTemplateRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_id")
    private String templateId;

    @JsonCreator
    public GetJWTTemplateRequest(String templateId) {
        Utils.checkNotNull(templateId, "templateId");
        this.templateId = templateId;
    }

    @JsonIgnore
    public String templateId() {
        return this.templateId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetJWTTemplateRequest withTemplateId(String templateId) {
        Utils.checkNotNull(templateId, "templateId");
        this.templateId = templateId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetJWTTemplateRequest other = (GetJWTTemplateRequest)o;
        return Objects.deepEquals(this.templateId, other.templateId);
    }

    public int hashCode() {
        return Objects.hash(this.templateId);
    }

    public String toString() {
        return Utils.toString(GetJWTTemplateRequest.class, "templateId", this.templateId);
    }

    public static final class Builder {
        private String templateId;

        private Builder() {
        }

        public Builder templateId(String templateId) {
            Utils.checkNotNull(templateId, "templateId");
            this.templateId = templateId;
            return this;
        }

        public GetJWTTemplateRequest build() {
            return new GetJWTTemplateRequest(this.templateId);
        }
    }
}

