/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.GetOAuthAccessTokenRequest;
import com.clerk.backend_api.models.operations.GetOAuthAccessTokenResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class GetOAuthAccessTokenRequestBuilder {
    private GetOAuthAccessTokenRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallGetOAuthAccessToken sdk;

    public GetOAuthAccessTokenRequestBuilder(SDKMethodInterfaces.MethodCallGetOAuthAccessToken sdk) {
        this.sdk = sdk;
    }

    public GetOAuthAccessTokenRequestBuilder request(GetOAuthAccessTokenRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public GetOAuthAccessTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public GetOAuthAccessTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public GetOAuthAccessTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getOAuthAccessToken(this.request, options);
    }
}

