/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OAuthAccessToken;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GetOAuthAccessTokenResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<OAuthAccessToken>> oAuthAccessToken;

    @JsonCreator
    public GetOAuthAccessTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<OAuthAccessToken>> oAuthAccessToken) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(oAuthAccessToken, "oAuthAccessToken");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.oAuthAccessToken = oAuthAccessToken;
    }

    public GetOAuthAccessTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<OAuthAccessToken>> oAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetOAuthAccessTokenResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetOAuthAccessTokenResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetOAuthAccessTokenResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetOAuthAccessTokenResponse withOAuthAccessToken(List<OAuthAccessToken> oAuthAccessToken) {
        Utils.checkNotNull(oAuthAccessToken, "oAuthAccessToken");
        this.oAuthAccessToken = Optional.ofNullable(oAuthAccessToken);
        return this;
    }

    public GetOAuthAccessTokenResponse withOAuthAccessToken(Optional<? extends List<OAuthAccessToken>> oAuthAccessToken) {
        Utils.checkNotNull(oAuthAccessToken, "oAuthAccessToken");
        this.oAuthAccessToken = oAuthAccessToken;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOAuthAccessTokenResponse other = (GetOAuthAccessTokenResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.oAuthAccessToken, other.oAuthAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.oAuthAccessToken);
    }

    public String toString() {
        return Utils.toString(GetOAuthAccessTokenResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "oAuthAccessToken", this.oAuthAccessToken);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<OAuthAccessToken>> oAuthAccessToken = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder oAuthAccessToken(List<OAuthAccessToken> oAuthAccessToken) {
            Utils.checkNotNull(oAuthAccessToken, "oAuthAccessToken");
            this.oAuthAccessToken = Optional.ofNullable(oAuthAccessToken);
            return this;
        }

        public Builder oAuthAccessToken(Optional<? extends List<OAuthAccessToken>> oAuthAccessToken) {
            Utils.checkNotNull(oAuthAccessToken, "oAuthAccessToken");
            this.oAuthAccessToken = oAuthAccessToken;
            return this;
        }

        public GetOAuthAccessTokenResponse build() {
            return new GetOAuthAccessTokenResponse(this.contentType, this.statusCode, this.rawResponse, this.oAuthAccessToken);
        }
    }
}

