/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class GetOrganizationInvitationRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=invitation_id")
    private String invitationId;

    @JsonCreator
    public GetOrganizationInvitationRequest(String organizationId, String invitationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(invitationId, "invitationId");
        this.organizationId = organizationId;
        this.invitationId = invitationId;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String invitationId() {
        return this.invitationId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetOrganizationInvitationRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public GetOrganizationInvitationRequest withInvitationId(String invitationId) {
        Utils.checkNotNull(invitationId, "invitationId");
        this.invitationId = invitationId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOrganizationInvitationRequest other = (GetOrganizationInvitationRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.invitationId, other.invitationId);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.invitationId);
    }

    public String toString() {
        return Utils.toString(GetOrganizationInvitationRequest.class, "organizationId", this.organizationId, "invitationId", this.invitationId);
    }

    public static final class Builder {
        private String organizationId;
        private String invitationId;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder invitationId(String invitationId) {
            Utils.checkNotNull(invitationId, "invitationId");
            this.invitationId = invitationId;
            return this;
        }

        public GetOrganizationInvitationRequest build() {
            return new GetOrganizationInvitationRequest(this.organizationId, this.invitationId);
        }
    }
}

