/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class GetOrganizationRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=include_members_count")
    private Optional<Boolean> includeMembersCount;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=include_missing_member_with_elevated_permissions")
    private Optional<Boolean> includeMissingMemberWithElevatedPermissions;

    @JsonCreator
    public GetOrganizationRequest(String organizationId, Optional<Boolean> includeMembersCount, Optional<Boolean> includeMissingMemberWithElevatedPermissions) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        this.organizationId = organizationId;
        this.includeMembersCount = includeMembersCount;
        this.includeMissingMemberWithElevatedPermissions = includeMissingMemberWithElevatedPermissions;
    }

    public GetOrganizationRequest(String organizationId) {
        this(organizationId, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<Boolean> includeMembersCount() {
        return this.includeMembersCount;
    }

    @JsonIgnore
    public Optional<Boolean> includeMissingMemberWithElevatedPermissions() {
        return this.includeMissingMemberWithElevatedPermissions;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetOrganizationRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public GetOrganizationRequest withIncludeMembersCount(boolean includeMembersCount) {
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        this.includeMembersCount = Optional.ofNullable(includeMembersCount);
        return this;
    }

    public GetOrganizationRequest withIncludeMembersCount(Optional<Boolean> includeMembersCount) {
        Utils.checkNotNull(includeMembersCount, "includeMembersCount");
        this.includeMembersCount = includeMembersCount;
        return this;
    }

    public GetOrganizationRequest withIncludeMissingMemberWithElevatedPermissions(boolean includeMissingMemberWithElevatedPermissions) {
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        this.includeMissingMemberWithElevatedPermissions = Optional.ofNullable(includeMissingMemberWithElevatedPermissions);
        return this;
    }

    public GetOrganizationRequest withIncludeMissingMemberWithElevatedPermissions(Optional<Boolean> includeMissingMemberWithElevatedPermissions) {
        Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
        this.includeMissingMemberWithElevatedPermissions = includeMissingMemberWithElevatedPermissions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOrganizationRequest other = (GetOrganizationRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.includeMembersCount, other.includeMembersCount) && Objects.deepEquals(this.includeMissingMemberWithElevatedPermissions, other.includeMissingMemberWithElevatedPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.includeMembersCount, this.includeMissingMemberWithElevatedPermissions);
    }

    public String toString() {
        return Utils.toString(GetOrganizationRequest.class, "organizationId", this.organizationId, "includeMembersCount", this.includeMembersCount, "includeMissingMemberWithElevatedPermissions", this.includeMissingMemberWithElevatedPermissions);
    }

    public static final class Builder {
        private String organizationId;
        private Optional<Boolean> includeMembersCount = Optional.empty();
        private Optional<Boolean> includeMissingMemberWithElevatedPermissions = Optional.empty();

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder includeMembersCount(boolean includeMembersCount) {
            Utils.checkNotNull(includeMembersCount, "includeMembersCount");
            this.includeMembersCount = Optional.ofNullable(includeMembersCount);
            return this;
        }

        public Builder includeMembersCount(Optional<Boolean> includeMembersCount) {
            Utils.checkNotNull(includeMembersCount, "includeMembersCount");
            this.includeMembersCount = includeMembersCount;
            return this;
        }

        public Builder includeMissingMemberWithElevatedPermissions(boolean includeMissingMemberWithElevatedPermissions) {
            Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
            this.includeMissingMemberWithElevatedPermissions = Optional.ofNullable(includeMissingMemberWithElevatedPermissions);
            return this;
        }

        public Builder includeMissingMemberWithElevatedPermissions(Optional<Boolean> includeMissingMemberWithElevatedPermissions) {
            Utils.checkNotNull(includeMissingMemberWithElevatedPermissions, "includeMissingMemberWithElevatedPermissions");
            this.includeMissingMemberWithElevatedPermissions = includeMissingMemberWithElevatedPermissions;
            return this;
        }

        public GetOrganizationRequest build() {
            return new GetOrganizationRequest(this.organizationId, this.includeMembersCount, this.includeMissingMemberWithElevatedPermissions);
        }
    }
}

