/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class GetPhoneNumberRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=phone_number_id")
    private String phoneNumberId;

    @JsonCreator
    public GetPhoneNumberRequest(String phoneNumberId) {
        Utils.checkNotNull(phoneNumberId, "phoneNumberId");
        this.phoneNumberId = phoneNumberId;
    }

    @JsonIgnore
    public String phoneNumberId() {
        return this.phoneNumberId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetPhoneNumberRequest withPhoneNumberId(String phoneNumberId) {
        Utils.checkNotNull(phoneNumberId, "phoneNumberId");
        this.phoneNumberId = phoneNumberId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPhoneNumberRequest other = (GetPhoneNumberRequest)o;
        return Objects.deepEquals(this.phoneNumberId, other.phoneNumberId);
    }

    public int hashCode() {
        return Objects.hash(this.phoneNumberId);
    }

    public String toString() {
        return Utils.toString(GetPhoneNumberRequest.class, "phoneNumberId", this.phoneNumberId);
    }

    public static final class Builder {
        private String phoneNumberId;

        private Builder() {
        }

        public Builder phoneNumberId(String phoneNumberId) {
            Utils.checkNotNull(phoneNumberId, "phoneNumberId");
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public GetPhoneNumberRequest build() {
            return new GetPhoneNumberRequest(this.phoneNumberId);
        }
    }
}

