/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.RedirectURL;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetRedirectURLResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends RedirectURL> redirectURL;

    @JsonCreator
    public GetRedirectURLResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends RedirectURL> redirectURL) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(redirectURL, "redirectURL");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.redirectURL = redirectURL;
    }

    public GetRedirectURLResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<RedirectURL> redirectURL() {
        return this.redirectURL;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetRedirectURLResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetRedirectURLResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetRedirectURLResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetRedirectURLResponse withRedirectURL(RedirectURL redirectURL) {
        Utils.checkNotNull(redirectURL, "redirectURL");
        this.redirectURL = Optional.ofNullable(redirectURL);
        return this;
    }

    public GetRedirectURLResponse withRedirectURL(Optional<? extends RedirectURL> redirectURL) {
        Utils.checkNotNull(redirectURL, "redirectURL");
        this.redirectURL = redirectURL;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRedirectURLResponse other = (GetRedirectURLResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.redirectURL, other.redirectURL);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.redirectURL);
    }

    public String toString() {
        return Utils.toString(GetRedirectURLResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "redirectURL", this.redirectURL);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends RedirectURL> redirectURL = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder redirectURL(RedirectURL redirectURL) {
            Utils.checkNotNull(redirectURL, "redirectURL");
            this.redirectURL = Optional.ofNullable(redirectURL);
            return this;
        }

        public Builder redirectURL(Optional<? extends RedirectURL> redirectURL) {
            Utils.checkNotNull(redirectURL, "redirectURL");
            this.redirectURL = redirectURL;
            return this;
        }

        public GetRedirectURLResponse build() {
            return new GetRedirectURLResponse(this.contentType, this.statusCode, this.rawResponse, this.redirectURL);
        }
    }
}

