/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class GetSAMLConnectionRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=saml_connection_id")
    private String samlConnectionId;

    @JsonCreator
    public GetSAMLConnectionRequest(String samlConnectionId) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        this.samlConnectionId = samlConnectionId;
    }

    @JsonIgnore
    public String samlConnectionId() {
        return this.samlConnectionId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetSAMLConnectionRequest withSamlConnectionId(String samlConnectionId) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        this.samlConnectionId = samlConnectionId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSAMLConnectionRequest other = (GetSAMLConnectionRequest)o;
        return Objects.deepEquals(this.samlConnectionId, other.samlConnectionId);
    }

    public int hashCode() {
        return Objects.hash(this.samlConnectionId);
    }

    public String toString() {
        return Utils.toString(GetSAMLConnectionRequest.class, "samlConnectionId", this.samlConnectionId);
    }

    public static final class Builder {
        private String samlConnectionId;

        private Builder() {
        }

        public Builder samlConnectionId(String samlConnectionId) {
            Utils.checkNotNull(samlConnectionId, "samlConnectionId");
            this.samlConnectionId = samlConnectionId;
            return this;
        }

        public GetSAMLConnectionRequest build() {
            return new GetSAMLConnectionRequest(this.samlConnectionId);
        }
    }
}

