/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.Session;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GetSessionListResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<Session>> sessionList;

    @JsonCreator
    public GetSessionListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<Session>> sessionList) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(sessionList, "sessionList");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.sessionList = sessionList;
    }

    public GetSessionListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<Session>> sessionList() {
        return this.sessionList;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetSessionListResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetSessionListResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetSessionListResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetSessionListResponse withSessionList(List<Session> sessionList) {
        Utils.checkNotNull(sessionList, "sessionList");
        this.sessionList = Optional.ofNullable(sessionList);
        return this;
    }

    public GetSessionListResponse withSessionList(Optional<? extends List<Session>> sessionList) {
        Utils.checkNotNull(sessionList, "sessionList");
        this.sessionList = sessionList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSessionListResponse other = (GetSessionListResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.sessionList, other.sessionList);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.sessionList);
    }

    public String toString() {
        return Utils.toString(GetSessionListResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "sessionList", this.sessionList);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<Session>> sessionList = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder sessionList(List<Session> sessionList) {
            Utils.checkNotNull(sessionList, "sessionList");
            this.sessionList = Optional.ofNullable(sessionList);
            return this;
        }

        public Builder sessionList(Optional<? extends List<Session>> sessionList) {
            Utils.checkNotNull(sessionList, "sessionList");
            this.sessionList = sessionList;
            return this;
        }

        public GetSessionListResponse build() {
            return new GetSessionListResponse(this.contentType, this.statusCode, this.rawResponse, this.sessionList);
        }
    }
}

