/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.AllowlistIdentifier;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ListAllowlistIdentifiersResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<AllowlistIdentifier>> allowlistIdentifierList;

    @JsonCreator
    public ListAllowlistIdentifiersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<AllowlistIdentifier>> allowlistIdentifierList) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(allowlistIdentifierList, "allowlistIdentifierList");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.allowlistIdentifierList = allowlistIdentifierList;
    }

    public ListAllowlistIdentifiersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<AllowlistIdentifier>> allowlistIdentifierList() {
        return this.allowlistIdentifierList;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ListAllowlistIdentifiersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListAllowlistIdentifiersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListAllowlistIdentifiersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListAllowlistIdentifiersResponse withAllowlistIdentifierList(List<AllowlistIdentifier> allowlistIdentifierList) {
        Utils.checkNotNull(allowlistIdentifierList, "allowlistIdentifierList");
        this.allowlistIdentifierList = Optional.ofNullable(allowlistIdentifierList);
        return this;
    }

    public ListAllowlistIdentifiersResponse withAllowlistIdentifierList(Optional<? extends List<AllowlistIdentifier>> allowlistIdentifierList) {
        Utils.checkNotNull(allowlistIdentifierList, "allowlistIdentifierList");
        this.allowlistIdentifierList = allowlistIdentifierList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListAllowlistIdentifiersResponse other = (ListAllowlistIdentifiersResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.allowlistIdentifierList, other.allowlistIdentifierList);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.allowlistIdentifierList);
    }

    public String toString() {
        return Utils.toString(ListAllowlistIdentifiersResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "allowlistIdentifierList", this.allowlistIdentifierList);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<AllowlistIdentifier>> allowlistIdentifierList = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder allowlistIdentifierList(List<AllowlistIdentifier> allowlistIdentifierList) {
            Utils.checkNotNull(allowlistIdentifierList, "allowlistIdentifierList");
            this.allowlistIdentifierList = Optional.ofNullable(allowlistIdentifierList);
            return this;
        }

        public Builder allowlistIdentifierList(Optional<? extends List<AllowlistIdentifier>> allowlistIdentifierList) {
            Utils.checkNotNull(allowlistIdentifierList, "allowlistIdentifierList");
            this.allowlistIdentifierList = allowlistIdentifierList;
            return this;
        }

        public ListAllowlistIdentifiersResponse build() {
            return new ListAllowlistIdentifiersResponse(this.contentType, this.statusCode, this.rawResponse, this.allowlistIdentifierList);
        }
    }
}

