/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.ListInvitationsQueryParamStatus;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class ListInvitationsRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=status")
    private Optional<? extends ListInvitationsQueryParamStatus> status;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=query")
    private Optional<String> query;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=order_by")
    private Optional<String> orderBy;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=paginated")
    private Optional<Boolean> paginated;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public ListInvitationsRequest(Optional<? extends ListInvitationsQueryParamStatus> status, Optional<String> query, Optional<String> orderBy, Optional<Boolean> paginated, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(paginated, "paginated");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.status = status;
        this.query = query;
        this.orderBy = orderBy;
        this.paginated = paginated;
        this.limit = limit;
        this.offset = offset;
    }

    public ListInvitationsRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<ListInvitationsQueryParamStatus> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> query() {
        return this.query;
    }

    @JsonIgnore
    public Optional<String> orderBy() {
        return this.orderBy;
    }

    @JsonIgnore
    public Optional<Boolean> paginated() {
        return this.paginated;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ListInvitationsRequest withStatus(ListInvitationsQueryParamStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public ListInvitationsRequest withStatus(Optional<? extends ListInvitationsQueryParamStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ListInvitationsRequest withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = Optional.ofNullable(query);
        return this;
    }

    public ListInvitationsRequest withQuery(Optional<String> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ListInvitationsRequest withOrderBy(String orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = Optional.ofNullable(orderBy);
        return this;
    }

    public ListInvitationsRequest withOrderBy(Optional<String> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    public ListInvitationsRequest withPaginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.ofNullable(paginated);
        return this;
    }

    public ListInvitationsRequest withPaginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public ListInvitationsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListInvitationsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListInvitationsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListInvitationsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListInvitationsRequest other = (ListInvitationsRequest)o;
        return Objects.deepEquals(this.status, other.status) && Objects.deepEquals(this.query, other.query) && Objects.deepEquals(this.orderBy, other.orderBy) && Objects.deepEquals(this.paginated, other.paginated) && Objects.deepEquals(this.limit, other.limit) && Objects.deepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.query, this.orderBy, this.paginated, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(ListInvitationsRequest.class, "status", this.status, "query", this.query, "orderBy", this.orderBy, "paginated", this.paginated, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private Optional<? extends ListInvitationsQueryParamStatus> status = Optional.empty();
        private Optional<String> query = Optional.empty();
        private Optional<String> orderBy = Optional.empty();
        private Optional<Boolean> paginated = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder status(ListInvitationsQueryParamStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<? extends ListInvitationsQueryParamStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = Optional.ofNullable(query);
            return this;
        }

        public Builder query(Optional<String> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder orderBy(String orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = Optional.ofNullable(orderBy);
            return this;
        }

        public Builder orderBy(Optional<String> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }

        public Builder paginated(boolean paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = Optional.ofNullable(paginated);
            return this;
        }

        public Builder paginated(Optional<Boolean> paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = paginated;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public ListInvitationsRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new ListInvitationsRequest(this.status, this.query, this.orderBy, this.paginated, this.limit, this.offset);
        }
    }
}

