/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.JWTTemplate;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ListJWTTemplatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends List<JWTTemplate>> jwtTemplateList;

    @JsonCreator
    public ListJWTTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends List<JWTTemplate>> jwtTemplateList) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(jwtTemplateList, "jwtTemplateList");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.jwtTemplateList = jwtTemplateList;
    }

    public ListJWTTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<List<JWTTemplate>> jwtTemplateList() {
        return this.jwtTemplateList;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ListJWTTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListJWTTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListJWTTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListJWTTemplatesResponse withJWTTemplateList(List<JWTTemplate> jwtTemplateList) {
        Utils.checkNotNull(jwtTemplateList, "jwtTemplateList");
        this.jwtTemplateList = Optional.ofNullable(jwtTemplateList);
        return this;
    }

    public ListJWTTemplatesResponse withJWTTemplateList(Optional<? extends List<JWTTemplate>> jwtTemplateList) {
        Utils.checkNotNull(jwtTemplateList, "jwtTemplateList");
        this.jwtTemplateList = jwtTemplateList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListJWTTemplatesResponse other = (ListJWTTemplatesResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.jwtTemplateList, other.jwtTemplateList);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.jwtTemplateList);
    }

    public String toString() {
        return Utils.toString(ListJWTTemplatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "jwtTemplateList", this.jwtTemplateList);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends List<JWTTemplate>> jwtTemplateList = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder jwtTemplateList(List<JWTTemplate> jwtTemplateList) {
            Utils.checkNotNull(jwtTemplateList, "jwtTemplateList");
            this.jwtTemplateList = Optional.ofNullable(jwtTemplateList);
            return this;
        }

        public Builder jwtTemplateList(Optional<? extends List<JWTTemplate>> jwtTemplateList) {
            Utils.checkNotNull(jwtTemplateList, "jwtTemplateList");
            this.jwtTemplateList = jwtTemplateList;
            return this;
        }

        public ListJWTTemplatesResponse build() {
            return new ListJWTTemplatesResponse(this.contentType, this.statusCode, this.rawResponse, this.jwtTemplateList);
        }
    }
}

