/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationDomains;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class ListOrganizationDomainsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationDomains> organizationDomains;

    @JsonCreator
    public ListOrganizationDomainsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationDomains> organizationDomains) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationDomains, "organizationDomains");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationDomains = organizationDomains;
    }

    public ListOrganizationDomainsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationDomains> organizationDomains() {
        return this.organizationDomains;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ListOrganizationDomainsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public ListOrganizationDomainsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public ListOrganizationDomainsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public ListOrganizationDomainsResponse withOrganizationDomains(OrganizationDomains organizationDomains) {
        Utils.checkNotNull(organizationDomains, "organizationDomains");
        this.organizationDomains = Optional.ofNullable(organizationDomains);
        return this;
    }

    public ListOrganizationDomainsResponse withOrganizationDomains(Optional<? extends OrganizationDomains> organizationDomains) {
        Utils.checkNotNull(organizationDomains, "organizationDomains");
        this.organizationDomains = organizationDomains;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOrganizationDomainsResponse other = (ListOrganizationDomainsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.organizationDomains, other.organizationDomains);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.organizationDomains);
    }

    public String toString() {
        return Utils.toString(ListOrganizationDomainsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationDomains", this.organizationDomains);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationDomains> organizationDomains = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationDomains(OrganizationDomains organizationDomains) {
            Utils.checkNotNull(organizationDomains, "organizationDomains");
            this.organizationDomains = Optional.ofNullable(organizationDomains);
            return this;
        }

        public Builder organizationDomains(Optional<? extends OrganizationDomains> organizationDomains) {
            Utils.checkNotNull(organizationDomains, "organizationDomains");
            this.organizationDomains = organizationDomains;
            return this;
        }

        public ListOrganizationDomainsResponse build() {
            return new ListOrganizationDomainsResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationDomains);
        }
    }
}

