/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.ListOrganizationInvitationsQueryParamStatus;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Objects;
import java.util.Optional;

public class ListOrganizationInvitationsRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=status")
    private Optional<? extends ListOrganizationInvitationsQueryParamStatus> status;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public ListOrganizationInvitationsRequest(String organizationId, Optional<? extends ListOrganizationInvitationsQueryParamStatus> status, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.organizationId = organizationId;
        this.status = status;
        this.limit = limit;
        this.offset = offset;
    }

    public ListOrganizationInvitationsRequest(String organizationId) {
        this(organizationId, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<ListOrganizationInvitationsQueryParamStatus> status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ListOrganizationInvitationsRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public ListOrganizationInvitationsRequest withStatus(ListOrganizationInvitationsQueryParamStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    public ListOrganizationInvitationsRequest withStatus(Optional<? extends ListOrganizationInvitationsQueryParamStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ListOrganizationInvitationsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public ListOrganizationInvitationsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public ListOrganizationInvitationsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public ListOrganizationInvitationsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOrganizationInvitationsRequest other = (ListOrganizationInvitationsRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.status, other.status) && Objects.deepEquals(this.limit, other.limit) && Objects.deepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.status, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(ListOrganizationInvitationsRequest.class, "organizationId", this.organizationId, "status", this.status, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private String organizationId;
        private Optional<? extends ListOrganizationInvitationsQueryParamStatus> status = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder status(ListOrganizationInvitationsQueryParamStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<? extends ListOrganizationInvitationsQueryParamStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public ListOrganizationInvitationsRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new ListOrganizationInvitationsRequest(this.organizationId, this.status, this.limit, this.offset);
        }
    }
}

