/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.Format;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class RefreshSessionRequestBody {
    @JsonProperty(value="expired_token")
    private String expiredToken;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="request_origin")
    private String requestOrigin;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="request_headers")
    private JsonNullable<? extends Map<String, Object>> requestHeaders;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="format")
    private JsonNullable<? extends Format> format;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="request_originating_ip")
    private JsonNullable<String> requestOriginatingIp;

    @JsonCreator
    public RefreshSessionRequestBody(@JsonProperty(value="expired_token") String expiredToken, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="request_origin") String requestOrigin, @JsonProperty(value="request_headers") JsonNullable<? extends Map<String, Object>> requestHeaders, @JsonProperty(value="format") JsonNullable<? extends Format> format, @JsonProperty(value="request_originating_ip") JsonNullable<String> requestOriginatingIp) {
        Utils.checkNotNull(expiredToken, "expiredToken");
        Utils.checkNotNull(refreshToken, "refreshToken");
        Utils.checkNotNull(requestOrigin, "requestOrigin");
        Utils.checkNotNull(requestHeaders, "requestHeaders");
        Utils.checkNotNull(format, "format");
        Utils.checkNotNull(requestOriginatingIp, "requestOriginatingIp");
        this.expiredToken = expiredToken;
        this.refreshToken = refreshToken;
        this.requestOrigin = requestOrigin;
        this.requestHeaders = requestHeaders;
        this.format = format;
        this.requestOriginatingIp = requestOriginatingIp;
    }

    public RefreshSessionRequestBody(String expiredToken, String refreshToken, String requestOrigin) {
        this(expiredToken, refreshToken, requestOrigin, (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Format>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String expiredToken() {
        return this.expiredToken;
    }

    @JsonIgnore
    public String refreshToken() {
        return this.refreshToken;
    }

    @JsonIgnore
    public String requestOrigin() {
        return this.requestOrigin;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> requestHeaders() {
        return this.requestHeaders;
    }

    @JsonIgnore
    public JsonNullable<Format> format() {
        return this.format;
    }

    @JsonIgnore
    public JsonNullable<String> requestOriginatingIp() {
        return this.requestOriginatingIp;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public RefreshSessionRequestBody withExpiredToken(String expiredToken) {
        Utils.checkNotNull(expiredToken, "expiredToken");
        this.expiredToken = expiredToken;
        return this;
    }

    public RefreshSessionRequestBody withRefreshToken(String refreshToken) {
        Utils.checkNotNull(refreshToken, "refreshToken");
        this.refreshToken = refreshToken;
        return this;
    }

    public RefreshSessionRequestBody withRequestOrigin(String requestOrigin) {
        Utils.checkNotNull(requestOrigin, "requestOrigin");
        this.requestOrigin = requestOrigin;
        return this;
    }

    public RefreshSessionRequestBody withRequestHeaders(Map<String, Object> requestHeaders) {
        Utils.checkNotNull(requestHeaders, "requestHeaders");
        this.requestHeaders = JsonNullable.of(requestHeaders);
        return this;
    }

    public RefreshSessionRequestBody withRequestHeaders(JsonNullable<? extends Map<String, Object>> requestHeaders) {
        Utils.checkNotNull(requestHeaders, "requestHeaders");
        this.requestHeaders = requestHeaders;
        return this;
    }

    public RefreshSessionRequestBody withFormat(Format format) {
        Utils.checkNotNull(format, "format");
        this.format = JsonNullable.of((Object)((Object)format));
        return this;
    }

    public RefreshSessionRequestBody withFormat(JsonNullable<? extends Format> format) {
        Utils.checkNotNull(format, "format");
        this.format = format;
        return this;
    }

    public RefreshSessionRequestBody withRequestOriginatingIp(String requestOriginatingIp) {
        Utils.checkNotNull(requestOriginatingIp, "requestOriginatingIp");
        this.requestOriginatingIp = JsonNullable.of((Object)requestOriginatingIp);
        return this;
    }

    public RefreshSessionRequestBody withRequestOriginatingIp(JsonNullable<String> requestOriginatingIp) {
        Utils.checkNotNull(requestOriginatingIp, "requestOriginatingIp");
        this.requestOriginatingIp = requestOriginatingIp;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshSessionRequestBody other = (RefreshSessionRequestBody)o;
        return Objects.deepEquals(this.expiredToken, other.expiredToken) && Objects.deepEquals(this.refreshToken, other.refreshToken) && Objects.deepEquals(this.requestOrigin, other.requestOrigin) && Objects.deepEquals(this.requestHeaders, other.requestHeaders) && Objects.deepEquals(this.format, other.format) && Objects.deepEquals(this.requestOriginatingIp, other.requestOriginatingIp);
    }

    public int hashCode() {
        return Objects.hash(this.expiredToken, this.refreshToken, this.requestOrigin, this.requestHeaders, this.format, this.requestOriginatingIp);
    }

    public String toString() {
        return Utils.toString(RefreshSessionRequestBody.class, "expiredToken", this.expiredToken, "refreshToken", this.refreshToken, "requestOrigin", this.requestOrigin, "requestHeaders", this.requestHeaders, "format", this.format, "requestOriginatingIp", this.requestOriginatingIp);
    }

    public static final class Builder {
        private String expiredToken;
        private String refreshToken;
        private String requestOrigin;
        private JsonNullable<? extends Map<String, Object>> requestHeaders = JsonNullable.undefined();
        private JsonNullable<? extends Format> format;
        private JsonNullable<String> requestOriginatingIp = JsonNullable.undefined();
        private static final LazySingletonValue<JsonNullable<? extends Format>> _SINGLETON_VALUE_Format = new LazySingletonValue<JsonNullable<? extends Format>>("format", "\"token\"", new TypeReference<JsonNullable<? extends Format>>(){});

        private Builder() {
        }

        public Builder expiredToken(String expiredToken) {
            Utils.checkNotNull(expiredToken, "expiredToken");
            this.expiredToken = expiredToken;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            Utils.checkNotNull(refreshToken, "refreshToken");
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder requestOrigin(String requestOrigin) {
            Utils.checkNotNull(requestOrigin, "requestOrigin");
            this.requestOrigin = requestOrigin;
            return this;
        }

        public Builder requestHeaders(Map<String, Object> requestHeaders) {
            Utils.checkNotNull(requestHeaders, "requestHeaders");
            this.requestHeaders = JsonNullable.of(requestHeaders);
            return this;
        }

        public Builder requestHeaders(JsonNullable<? extends Map<String, Object>> requestHeaders) {
            Utils.checkNotNull(requestHeaders, "requestHeaders");
            this.requestHeaders = requestHeaders;
            return this;
        }

        public Builder format(Format format) {
            Utils.checkNotNull(format, "format");
            this.format = JsonNullable.of((Object)((Object)format));
            return this;
        }

        public Builder format(JsonNullable<? extends Format> format) {
            Utils.checkNotNull(format, "format");
            this.format = format;
            return this;
        }

        public Builder requestOriginatingIp(String requestOriginatingIp) {
            Utils.checkNotNull(requestOriginatingIp, "requestOriginatingIp");
            this.requestOriginatingIp = JsonNullable.of((Object)requestOriginatingIp);
            return this;
        }

        public Builder requestOriginatingIp(JsonNullable<String> requestOriginatingIp) {
            Utils.checkNotNull(requestOriginatingIp, "requestOriginatingIp");
            this.requestOriginatingIp = requestOriginatingIp;
            return this;
        }

        public RefreshSessionRequestBody build() {
            if (this.format == null) {
                this.format = _SINGLETON_VALUE_Format.value();
            }
            return new RefreshSessionRequestBody(this.expiredToken, this.refreshToken, this.requestOrigin, this.requestHeaders, this.format, this.requestOriginatingIp);
        }
    }
}

