/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.RevokeActorTokenResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RevokeActorTokenRequestBuilder {
    private String actorTokenId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallRevokeActorToken sdk;

    public RevokeActorTokenRequestBuilder(SDKMethodInterfaces.MethodCallRevokeActorToken sdk) {
        this.sdk = sdk;
    }

    public RevokeActorTokenRequestBuilder actorTokenId(String actorTokenId) {
        Utils.checkNotNull(actorTokenId, "actorTokenId");
        this.actorTokenId = actorTokenId;
        return this;
    }

    public RevokeActorTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RevokeActorTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public RevokeActorTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.revoke(this.actorTokenId, options);
    }
}

