/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.RevokeSignInTokenResponse;
import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RevokeSignInTokenRequestBuilder {
    private String signInTokenId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallRevokeSignInToken sdk;

    public RevokeSignInTokenRequestBuilder(SDKMethodInterfaces.MethodCallRevokeSignInToken sdk) {
        this.sdk = sdk;
    }

    public RevokeSignInTokenRequestBuilder signInTokenId(String signInTokenId) {
        Utils.checkNotNull(signInTokenId, "signInTokenId");
        this.signInTokenId = signInTokenId;
        return this;
    }

    public RevokeSignInTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RevokeSignInTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public RevokeSignInTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.revoke(this.signInTokenId, options);
    }
}

