/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.File;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class SetUserProfileImageRequestBody {
    @SpeakeasyMetadata(value="multipartForm:file,name=file")
    private Optional<? extends File> file;

    @JsonCreator
    public SetUserProfileImageRequestBody(Optional<? extends File> file) {
        Utils.checkNotNull(file, "file");
        this.file = file;
    }

    public SetUserProfileImageRequestBody() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<File> file() {
        return this.file;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public SetUserProfileImageRequestBody withFile(File file) {
        Utils.checkNotNull(file, "file");
        this.file = Optional.ofNullable(file);
        return this;
    }

    public SetUserProfileImageRequestBody withFile(Optional<? extends File> file) {
        Utils.checkNotNull(file, "file");
        this.file = file;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetUserProfileImageRequestBody other = (SetUserProfileImageRequestBody)o;
        return Objects.deepEquals(this.file, other.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public String toString() {
        return Utils.toString(SetUserProfileImageRequestBody.class, "file", this.file);
    }

    public static final class Builder {
        private Optional<? extends File> file = Optional.empty();

        private Builder() {
        }

        public Builder file(File file) {
            Utils.checkNotNull(file, "file");
            this.file = Optional.ofNullable(file);
            return this;
        }

        public Builder file(Optional<? extends File> file) {
            Utils.checkNotNull(file, "file");
            this.file = file;
            return this;
        }

        public SetUserProfileImageRequestBody build() {
            return new SetUserProfileImageRequestBody(this.file);
        }
    }
}

