/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateDomainRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class UpdateDomainRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=domain_id")
    private String domainId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UpdateDomainRequestBody requestBody;

    @JsonCreator
    public UpdateDomainRequest(String domainId, UpdateDomainRequestBody requestBody) {
        Utils.checkNotNull(domainId, "domainId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.domainId = domainId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String domainId() {
        return this.domainId;
    }

    @JsonIgnore
    public UpdateDomainRequestBody requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateDomainRequest withDomainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public UpdateDomainRequest withRequestBody(UpdateDomainRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest)o;
        return Objects.deepEquals(this.domainId, other.domainId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.domainId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateDomainRequest.class, "domainId", this.domainId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String domainId;
        private UpdateDomainRequestBody requestBody;

        private Builder() {
        }

        public Builder domainId(String domainId) {
            Utils.checkNotNull(domainId, "domainId");
            this.domainId = domainId;
            return this;
        }

        public Builder requestBody(UpdateDomainRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this.domainId, this.requestBody);
        }
    }
}

