/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class UpdateOrganizationDomainRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=domain_id")
    private String domainId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UpdateOrganizationDomainRequestBody requestBody;

    @JsonCreator
    public UpdateOrganizationDomainRequest(String organizationId, String domainId, UpdateOrganizationDomainRequestBody requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(domainId, "domainId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.domainId = domainId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String domainId() {
        return this.domainId;
    }

    @JsonIgnore
    public UpdateOrganizationDomainRequestBody requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateOrganizationDomainRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public UpdateOrganizationDomainRequest withDomainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public UpdateOrganizationDomainRequest withRequestBody(UpdateOrganizationDomainRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOrganizationDomainRequest other = (UpdateOrganizationDomainRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.domainId, other.domainId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.domainId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateOrganizationDomainRequest.class, "organizationId", this.organizationId, "domainId", this.domainId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private String domainId;
        private UpdateOrganizationDomainRequestBody requestBody;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder domainId(String domainId) {
            Utils.checkNotNull(domainId, "domainId");
            this.domainId = domainId;
            return this;
        }

        public Builder requestBody(UpdateOrganizationDomainRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateOrganizationDomainRequest build() {
            return new UpdateOrganizationDomainRequest(this.organizationId, this.domainId, this.requestBody);
        }
    }
}

