/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipMetadataRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class UpdateOrganizationMembershipMetadataRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends UpdateOrganizationMembershipMetadataRequestBody> requestBody;

    @JsonCreator
    public UpdateOrganizationMembershipMetadataRequest(String organizationId, String userId, Optional<? extends UpdateOrganizationMembershipMetadataRequestBody> requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.userId = userId;
        this.requestBody = requestBody;
    }

    public UpdateOrganizationMembershipMetadataRequest(String organizationId, String userId) {
        this(organizationId, userId, Optional.empty());
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<UpdateOrganizationMembershipMetadataRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateOrganizationMembershipMetadataRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public UpdateOrganizationMembershipMetadataRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UpdateOrganizationMembershipMetadataRequest withRequestBody(UpdateOrganizationMembershipMetadataRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UpdateOrganizationMembershipMetadataRequest withRequestBody(Optional<? extends UpdateOrganizationMembershipMetadataRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOrganizationMembershipMetadataRequest other = (UpdateOrganizationMembershipMetadataRequest)o;
        return Objects.deepEquals(this.organizationId, other.organizationId) && Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.userId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateOrganizationMembershipMetadataRequest.class, "organizationId", this.organizationId, "userId", this.userId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private String userId;
        private Optional<? extends UpdateOrganizationMembershipMetadataRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder requestBody(UpdateOrganizationMembershipMetadataRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UpdateOrganizationMembershipMetadataRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateOrganizationMembershipMetadataRequest build() {
            return new UpdateOrganizationMembershipMetadataRequest(this.organizationId, this.userId, this.requestBody);
        }
    }
}

