/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipResponse;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateOrganizationMembershipRequestBuilder {
    private String organizationId;
    private String userId;
    private UpdateOrganizationMembershipRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallUpdateOrganizationMembership sdk;

    public UpdateOrganizationMembershipRequestBuilder(SDKMethodInterfaces.MethodCallUpdateOrganizationMembership sdk) {
        this.sdk = sdk;
    }

    public UpdateOrganizationMembershipRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder requestBody(UpdateOrganizationMembershipRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public UpdateOrganizationMembershipResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.update(this.organizationId, this.userId, this.requestBody, options);
    }
}

