/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class UpdateSAMLConnectionAttributeMapping {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="user_id")
    private Optional<String> userId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="email_address")
    private Optional<String> emailAddress;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="first_name")
    private Optional<String> firstName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="last_name")
    private Optional<String> lastName;

    @JsonCreator
    public UpdateSAMLConnectionAttributeMapping(@JsonProperty(value="user_id") Optional<String> userId, @JsonProperty(value="email_address") Optional<String> emailAddress, @JsonProperty(value="first_name") Optional<String> firstName, @JsonProperty(value="last_name") Optional<String> lastName) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        this.userId = userId;
        this.emailAddress = emailAddress;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public UpdateSAMLConnectionAttributeMapping() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<String> emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public Optional<String> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> lastName() {
        return this.lastName;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateSAMLConnectionAttributeMapping withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = Optional.ofNullable(userId);
        return this;
    }

    public UpdateSAMLConnectionAttributeMapping withUserId(Optional<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UpdateSAMLConnectionAttributeMapping withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = Optional.ofNullable(emailAddress);
        return this;
    }

    public UpdateSAMLConnectionAttributeMapping withEmailAddress(Optional<String> emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public UpdateSAMLConnectionAttributeMapping withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }

    public UpdateSAMLConnectionAttributeMapping withFirstName(Optional<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public UpdateSAMLConnectionAttributeMapping withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }

    public UpdateSAMLConnectionAttributeMapping withLastName(Optional<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSAMLConnectionAttributeMapping other = (UpdateSAMLConnectionAttributeMapping)o;
        return Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.emailAddress, other.emailAddress) && Objects.deepEquals(this.firstName, other.firstName) && Objects.deepEquals(this.lastName, other.lastName);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.emailAddress, this.firstName, this.lastName);
    }

    public String toString() {
        return Utils.toString(UpdateSAMLConnectionAttributeMapping.class, "userId", this.userId, "emailAddress", this.emailAddress, "firstName", this.firstName, "lastName", this.lastName);
    }

    public static final class Builder {
        private Optional<String> userId = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        public Builder userId(Optional<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Optional<String> emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public UpdateSAMLConnectionAttributeMapping build() {
            return new UpdateSAMLConnectionAttributeMapping(this.userId, this.emailAddress, this.firstName, this.lastName);
        }
    }
}

