/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UploadOrganizationLogoFile;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class UploadOrganizationLogoRequestBody {
    @SpeakeasyMetadata(value="multipartForm:name=uploader_user_id")
    private Optional<String> uploaderUserId;
    @SpeakeasyMetadata(value="multipartForm:file,name=file")
    private UploadOrganizationLogoFile file;

    @JsonCreator
    public UploadOrganizationLogoRequestBody(Optional<String> uploaderUserId, UploadOrganizationLogoFile file) {
        Utils.checkNotNull(uploaderUserId, "uploaderUserId");
        Utils.checkNotNull(file, "file");
        this.uploaderUserId = uploaderUserId;
        this.file = file;
    }

    public UploadOrganizationLogoRequestBody(UploadOrganizationLogoFile file) {
        this(Optional.empty(), file);
    }

    @JsonIgnore
    public Optional<String> uploaderUserId() {
        return this.uploaderUserId;
    }

    @JsonIgnore
    public UploadOrganizationLogoFile file() {
        return this.file;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UploadOrganizationLogoRequestBody withUploaderUserId(String uploaderUserId) {
        Utils.checkNotNull(uploaderUserId, "uploaderUserId");
        this.uploaderUserId = Optional.ofNullable(uploaderUserId);
        return this;
    }

    public UploadOrganizationLogoRequestBody withUploaderUserId(Optional<String> uploaderUserId) {
        Utils.checkNotNull(uploaderUserId, "uploaderUserId");
        this.uploaderUserId = uploaderUserId;
        return this;
    }

    public UploadOrganizationLogoRequestBody withFile(UploadOrganizationLogoFile file) {
        Utils.checkNotNull(file, "file");
        this.file = file;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadOrganizationLogoRequestBody other = (UploadOrganizationLogoRequestBody)o;
        return Objects.deepEquals(this.uploaderUserId, other.uploaderUserId) && Objects.deepEquals(this.file, other.file);
    }

    public int hashCode() {
        return Objects.hash(this.uploaderUserId, this.file);
    }

    public String toString() {
        return Utils.toString(UploadOrganizationLogoRequestBody.class, "uploaderUserId", this.uploaderUserId, "file", this.file);
    }

    public static final class Builder {
        private Optional<String> uploaderUserId = Optional.empty();
        private UploadOrganizationLogoFile file;

        private Builder() {
        }

        public Builder uploaderUserId(String uploaderUserId) {
            Utils.checkNotNull(uploaderUserId, "uploaderUserId");
            this.uploaderUserId = Optional.ofNullable(uploaderUserId);
            return this;
        }

        public Builder uploaderUserId(Optional<String> uploaderUserId) {
            Utils.checkNotNull(uploaderUserId, "uploaderUserId");
            this.uploaderUserId = uploaderUserId;
            return this;
        }

        public Builder file(UploadOrganizationLogoFile file) {
            Utils.checkNotNull(file, "file");
            this.file = file;
            return this;
        }

        public UploadOrganizationLogoRequestBody build() {
            return new UploadOrganizationLogoRequestBody(this.uploaderUserId, this.file);
        }
    }
}

