/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class UpsertTemplateRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private Optional<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="subject")
    private JsonNullable<String> subject;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="markup")
    private JsonNullable<String> markup;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="body")
    private Optional<String> body;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="delivered_by_clerk")
    private JsonNullable<Boolean> deliveredByClerk;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="from_email_name")
    private Optional<String> fromEmailName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="reply_to_email_name")
    private Optional<String> replyToEmailName;

    @JsonCreator
    public UpsertTemplateRequestBody(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="subject") JsonNullable<String> subject, @JsonProperty(value="markup") JsonNullable<String> markup, @JsonProperty(value="body") Optional<String> body, @JsonProperty(value="delivered_by_clerk") JsonNullable<Boolean> deliveredByClerk, @JsonProperty(value="from_email_name") Optional<String> fromEmailName, @JsonProperty(value="reply_to_email_name") Optional<String> replyToEmailName) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(markup, "markup");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
        Utils.checkNotNull(fromEmailName, "fromEmailName");
        Utils.checkNotNull(replyToEmailName, "replyToEmailName");
        this.name = name;
        this.subject = subject;
        this.markup = markup;
        this.body = body;
        this.deliveredByClerk = deliveredByClerk;
        this.fromEmailName = fromEmailName;
        this.replyToEmailName = replyToEmailName;
    }

    public UpsertTemplateRequestBody() {
        this(Optional.empty(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<Boolean>)JsonNullable.undefined(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> name() {
        return this.name;
    }

    @JsonIgnore
    public JsonNullable<String> subject() {
        return this.subject;
    }

    @JsonIgnore
    public JsonNullable<String> markup() {
        return this.markup;
    }

    @JsonIgnore
    public Optional<String> body() {
        return this.body;
    }

    @JsonIgnore
    public JsonNullable<Boolean> deliveredByClerk() {
        return this.deliveredByClerk;
    }

    @JsonIgnore
    public Optional<String> fromEmailName() {
        return this.fromEmailName;
    }

    @JsonIgnore
    public Optional<String> replyToEmailName() {
        return this.replyToEmailName;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpsertTemplateRequestBody withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public UpsertTemplateRequestBody withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public UpsertTemplateRequestBody withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = JsonNullable.of((Object)subject);
        return this;
    }

    public UpsertTemplateRequestBody withSubject(JsonNullable<String> subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    public UpsertTemplateRequestBody withMarkup(String markup) {
        Utils.checkNotNull(markup, "markup");
        this.markup = JsonNullable.of((Object)markup);
        return this;
    }

    public UpsertTemplateRequestBody withMarkup(JsonNullable<String> markup) {
        Utils.checkNotNull(markup, "markup");
        this.markup = markup;
        return this;
    }

    public UpsertTemplateRequestBody withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = Optional.ofNullable(body);
        return this;
    }

    public UpsertTemplateRequestBody withBody(Optional<String> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public UpsertTemplateRequestBody withDeliveredByClerk(boolean deliveredByClerk) {
        Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
        this.deliveredByClerk = JsonNullable.of((Object)deliveredByClerk);
        return this;
    }

    public UpsertTemplateRequestBody withDeliveredByClerk(JsonNullable<Boolean> deliveredByClerk) {
        Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
        this.deliveredByClerk = deliveredByClerk;
        return this;
    }

    public UpsertTemplateRequestBody withFromEmailName(String fromEmailName) {
        Utils.checkNotNull(fromEmailName, "fromEmailName");
        this.fromEmailName = Optional.ofNullable(fromEmailName);
        return this;
    }

    public UpsertTemplateRequestBody withFromEmailName(Optional<String> fromEmailName) {
        Utils.checkNotNull(fromEmailName, "fromEmailName");
        this.fromEmailName = fromEmailName;
        return this;
    }

    public UpsertTemplateRequestBody withReplyToEmailName(String replyToEmailName) {
        Utils.checkNotNull(replyToEmailName, "replyToEmailName");
        this.replyToEmailName = Optional.ofNullable(replyToEmailName);
        return this;
    }

    public UpsertTemplateRequestBody withReplyToEmailName(Optional<String> replyToEmailName) {
        Utils.checkNotNull(replyToEmailName, "replyToEmailName");
        this.replyToEmailName = replyToEmailName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertTemplateRequestBody other = (UpsertTemplateRequestBody)o;
        return Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.subject, other.subject) && Objects.deepEquals(this.markup, other.markup) && Objects.deepEquals(this.body, other.body) && Objects.deepEquals(this.deliveredByClerk, other.deliveredByClerk) && Objects.deepEquals(this.fromEmailName, other.fromEmailName) && Objects.deepEquals(this.replyToEmailName, other.replyToEmailName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.subject, this.markup, this.body, this.deliveredByClerk, this.fromEmailName, this.replyToEmailName);
    }

    public String toString() {
        return Utils.toString(UpsertTemplateRequestBody.class, "name", this.name, "subject", this.subject, "markup", this.markup, "body", this.body, "deliveredByClerk", this.deliveredByClerk, "fromEmailName", this.fromEmailName, "replyToEmailName", this.replyToEmailName);
    }

    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private JsonNullable<String> subject = JsonNullable.undefined();
        private JsonNullable<String> markup = JsonNullable.undefined();
        private Optional<String> body = Optional.empty();
        private JsonNullable<Boolean> deliveredByClerk = JsonNullable.undefined();
        private Optional<String> fromEmailName = Optional.empty();
        private Optional<String> replyToEmailName = Optional.empty();

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = JsonNullable.of((Object)subject);
            return this;
        }

        public Builder subject(JsonNullable<String> subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }

        public Builder markup(String markup) {
            Utils.checkNotNull(markup, "markup");
            this.markup = JsonNullable.of((Object)markup);
            return this;
        }

        public Builder markup(JsonNullable<String> markup) {
            Utils.checkNotNull(markup, "markup");
            this.markup = markup;
            return this;
        }

        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = Optional.ofNullable(body);
            return this;
        }

        public Builder body(Optional<String> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public Builder deliveredByClerk(boolean deliveredByClerk) {
            Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
            this.deliveredByClerk = JsonNullable.of((Object)deliveredByClerk);
            return this;
        }

        public Builder deliveredByClerk(JsonNullable<Boolean> deliveredByClerk) {
            Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
            this.deliveredByClerk = deliveredByClerk;
            return this;
        }

        public Builder fromEmailName(String fromEmailName) {
            Utils.checkNotNull(fromEmailName, "fromEmailName");
            this.fromEmailName = Optional.ofNullable(fromEmailName);
            return this;
        }

        public Builder fromEmailName(Optional<String> fromEmailName) {
            Utils.checkNotNull(fromEmailName, "fromEmailName");
            this.fromEmailName = fromEmailName;
            return this;
        }

        public Builder replyToEmailName(String replyToEmailName) {
            Utils.checkNotNull(replyToEmailName, "replyToEmailName");
            this.replyToEmailName = Optional.ofNullable(replyToEmailName);
            return this;
        }

        public Builder replyToEmailName(Optional<String> replyToEmailName) {
            Utils.checkNotNull(replyToEmailName, "replyToEmailName");
            this.replyToEmailName = replyToEmailName;
            return this;
        }

        public UpsertTemplateRequestBody build() {
            return new UpsertTemplateRequestBody(this.name, this.subject, this.markup, this.body, this.deliveredByClerk, this.fromEmailName, this.replyToEmailName);
        }
    }
}

