/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.SDKMethodInterfaces;
import com.clerk.backend_api.models.operations.UserWeb3WalletDeleteResponse;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UserWeb3WalletDeleteRequestBuilder {
    private String userId;
    private String web3WalletIdentificationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallUserWeb3WalletDelete sdk;

    public UserWeb3WalletDeleteRequestBuilder(SDKMethodInterfaces.MethodCallUserWeb3WalletDelete sdk) {
        this.sdk = sdk;
    }

    public UserWeb3WalletDeleteRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UserWeb3WalletDeleteRequestBuilder web3WalletIdentificationId(String web3WalletIdentificationId) {
        Utils.checkNotNull(web3WalletIdentificationId, "web3WalletIdentificationId");
        this.web3WalletIdentificationId = web3WalletIdentificationId;
        return this;
    }

    public UserWeb3WalletDeleteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UserWeb3WalletDeleteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public UserWeb3WalletDeleteResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.deleteWeb3Wallet(this.userId, this.web3WalletIdentificationId, options);
    }
}

