/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.VerifySessionRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class VerifySessionRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=session_id")
    private String sessionId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends VerifySessionRequestBody> requestBody;

    @JsonCreator
    public VerifySessionRequest(String sessionId, Optional<? extends VerifySessionRequestBody> requestBody) {
        Utils.checkNotNull(sessionId, "sessionId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.sessionId = sessionId;
        this.requestBody = requestBody;
    }

    public VerifySessionRequest(String sessionId) {
        this(sessionId, Optional.empty());
    }

    @JsonIgnore
    public String sessionId() {
        return this.sessionId;
    }

    @JsonIgnore
    public Optional<VerifySessionRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public VerifySessionRequest withSessionId(String sessionId) {
        Utils.checkNotNull(sessionId, "sessionId");
        this.sessionId = sessionId;
        return this;
    }

    public VerifySessionRequest withRequestBody(VerifySessionRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public VerifySessionRequest withRequestBody(Optional<? extends VerifySessionRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifySessionRequest other = (VerifySessionRequest)o;
        return Objects.deepEquals(this.sessionId, other.sessionId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(VerifySessionRequest.class, "sessionId", this.sessionId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String sessionId;
        private Optional<? extends VerifySessionRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder sessionId(String sessionId) {
            Utils.checkNotNull(sessionId, "sessionId");
            this.sessionId = sessionId;
            return this;
        }

        public Builder requestBody(VerifySessionRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends VerifySessionRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public VerifySessionRequest build() {
            return new VerifySessionRequest(this.sessionId, this.requestBody);
        }
    }
}

