/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.VerifyTOTPRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class VerifyTOTPRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends VerifyTOTPRequestBody> requestBody;

    @JsonCreator
    public VerifyTOTPRequest(String userId, Optional<? extends VerifyTOTPRequestBody> requestBody) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.userId = userId;
        this.requestBody = requestBody;
    }

    public VerifyTOTPRequest(String userId) {
        this(userId, Optional.empty());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<VerifyTOTPRequestBody> requestBody() {
        return this.requestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public VerifyTOTPRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public VerifyTOTPRequest withRequestBody(VerifyTOTPRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public VerifyTOTPRequest withRequestBody(Optional<? extends VerifyTOTPRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyTOTPRequest other = (VerifyTOTPRequest)o;
        return Objects.deepEquals(this.userId, other.userId) && Objects.deepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(VerifyTOTPRequest.class, "userId", this.userId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String userId;
        private Optional<? extends VerifyTOTPRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder requestBody(VerifyTOTPRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends VerifyTOTPRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public VerifyTOTPRequest build() {
            return new VerifyTOTPRequest(this.userId, this.requestBody);
        }
    }
}

