/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.ActorTokens;
import com.clerk.backend_api.AllowlistIdentifiers;
import com.clerk.backend_api.AwsCredentials;
import com.clerk.backend_api.BetaFeatures;
import com.clerk.backend_api.BlocklistIdentifiers;
import com.clerk.backend_api.Clients;
import com.clerk.backend_api.Commerce;
import com.clerk.backend_api.Domains;
import com.clerk.backend_api.EmailAddresses;
import com.clerk.backend_api.EmailAndSmsTemplates;
import com.clerk.backend_api.EmailSMSTemplates;
import com.clerk.backend_api.ExperimentalAccountlessApplications;
import com.clerk.backend_api.InstanceSettings;
import com.clerk.backend_api.Invitations;
import com.clerk.backend_api.Jwks;
import com.clerk.backend_api.JwtTemplates;
import com.clerk.backend_api.M2m;
import com.clerk.backend_api.Machines;
import com.clerk.backend_api.Miscellaneous;
import com.clerk.backend_api.OauthAccessTokens;
import com.clerk.backend_api.OauthApplications;
import com.clerk.backend_api.OrganizationDomains;
import com.clerk.backend_api.OrganizationInvitations;
import com.clerk.backend_api.OrganizationMemberships;
import com.clerk.backend_api.Organizations;
import com.clerk.backend_api.PhoneNumbers;
import com.clerk.backend_api.ProxyChecks;
import com.clerk.backend_api.RedirectUrls;
import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.SamlConnections;
import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.Sessions;
import com.clerk.backend_api.SignInTokens;
import com.clerk.backend_api.SignUps;
import com.clerk.backend_api.Templates;
import com.clerk.backend_api.TestingTokens;
import com.clerk.backend_api.Users;
import com.clerk.backend_api.WaitlistEntries;
import com.clerk.backend_api.Webhooks;
import com.clerk.backend_api.models.components.Security;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.Hook;
import com.clerk.backend_api.utils.Hooks;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class Clerk {
    public static final String[] SERVERS = new String[]{"https://api.clerk.com/v1"};
    private final Miscellaneous miscellaneous;
    private final Jwks jwks;
    private final AwsCredentials awsCredentials;
    private final Clients clients;
    private final EmailAddresses emailAddresses;
    private final PhoneNumbers phoneNumbers;
    private final Sessions sessions;
    private final EmailSMSTemplates emailSMSTemplates;
    private final EmailAndSmsTemplates emailAndSmsTemplates;
    private final Templates templates;
    private final Users users;
    private final Invitations invitations;
    private final OrganizationInvitations organizationInvitations;
    private final AllowlistIdentifiers allowlistIdentifiers;
    private final BlocklistIdentifiers blocklistIdentifiers;
    private final BetaFeatures betaFeatures;
    private final ActorTokens actorTokens;
    private final Domains domains;
    private final InstanceSettings instanceSettings;
    private final Webhooks webhooks;
    private final JwtTemplates jwtTemplates;
    private final Machines machines;
    private final Organizations organizations;
    private final OrganizationMemberships organizationMemberships;
    private final OrganizationDomains organizationDomains;
    private final ProxyChecks proxyChecks;
    private final RedirectUrls redirectUrls;
    private final SignInTokens signInTokens;
    private final SignUps signUps;
    private final OauthApplications oauthApplications;
    private final SamlConnections samlConnections;
    private final TestingTokens testingTokens;
    private final WaitlistEntries waitlistEntries;
    private final ExperimentalAccountlessApplications experimentalAccountlessApplications;
    private final Commerce commerce;
    private final M2m m2m;
    private final OauthAccessTokens oauthAccessTokens;
    private final SDKConfiguration sdkConfiguration;

    public Miscellaneous miscellaneous() {
        return this.miscellaneous;
    }

    public Jwks jwks() {
        return this.jwks;
    }

    public AwsCredentials awsCredentials() {
        return this.awsCredentials;
    }

    public Clients clients() {
        return this.clients;
    }

    public EmailAddresses emailAddresses() {
        return this.emailAddresses;
    }

    public PhoneNumbers phoneNumbers() {
        return this.phoneNumbers;
    }

    public Sessions sessions() {
        return this.sessions;
    }

    public EmailSMSTemplates emailSMSTemplates() {
        return this.emailSMSTemplates;
    }

    public EmailAndSmsTemplates emailAndSmsTemplates() {
        return this.emailAndSmsTemplates;
    }

    public Templates templates() {
        return this.templates;
    }

    public Users users() {
        return this.users;
    }

    public Invitations invitations() {
        return this.invitations;
    }

    public OrganizationInvitations organizationInvitations() {
        return this.organizationInvitations;
    }

    public AllowlistIdentifiers allowlistIdentifiers() {
        return this.allowlistIdentifiers;
    }

    public BlocklistIdentifiers blocklistIdentifiers() {
        return this.blocklistIdentifiers;
    }

    public BetaFeatures betaFeatures() {
        return this.betaFeatures;
    }

    public ActorTokens actorTokens() {
        return this.actorTokens;
    }

    public Domains domains() {
        return this.domains;
    }

    public InstanceSettings instanceSettings() {
        return this.instanceSettings;
    }

    public Webhooks webhooks() {
        return this.webhooks;
    }

    public JwtTemplates jwtTemplates() {
        return this.jwtTemplates;
    }

    public Machines machines() {
        return this.machines;
    }

    public Organizations organizations() {
        return this.organizations;
    }

    public OrganizationMemberships organizationMemberships() {
        return this.organizationMemberships;
    }

    public OrganizationDomains organizationDomains() {
        return this.organizationDomains;
    }

    public ProxyChecks proxyChecks() {
        return this.proxyChecks;
    }

    public RedirectUrls redirectUrls() {
        return this.redirectUrls;
    }

    public SignInTokens signInTokens() {
        return this.signInTokens;
    }

    public SignUps signUps() {
        return this.signUps;
    }

    public OauthApplications oauthApplications() {
        return this.oauthApplications;
    }

    public SamlConnections samlConnections() {
        return this.samlConnections;
    }

    public TestingTokens testingTokens() {
        return this.testingTokens;
    }

    public WaitlistEntries waitlistEntries() {
        return this.waitlistEntries;
    }

    public ExperimentalAccountlessApplications experimentalAccountlessApplications() {
        return this.experimentalAccountlessApplications;
    }

    public Commerce commerce() {
        return this.commerce;
    }

    public M2m m2m() {
        return this.m2m;
    }

    public OauthAccessTokens oauthAccessTokens() {
        return this.oauthAccessTokens;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Clerk(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.sdkConfiguration.initialize();
        this.miscellaneous = new Miscellaneous(sdkConfiguration);
        this.jwks = new Jwks(sdkConfiguration);
        this.awsCredentials = new AwsCredentials(sdkConfiguration);
        this.clients = new Clients(sdkConfiguration);
        this.emailAddresses = new EmailAddresses(sdkConfiguration);
        this.phoneNumbers = new PhoneNumbers(sdkConfiguration);
        this.sessions = new Sessions(sdkConfiguration);
        this.emailSMSTemplates = new EmailSMSTemplates(sdkConfiguration);
        this.emailAndSmsTemplates = new EmailAndSmsTemplates(sdkConfiguration);
        this.templates = new Templates(sdkConfiguration);
        this.users = new Users(sdkConfiguration);
        this.invitations = new Invitations(sdkConfiguration);
        this.organizationInvitations = new OrganizationInvitations(sdkConfiguration);
        this.allowlistIdentifiers = new AllowlistIdentifiers(sdkConfiguration);
        this.blocklistIdentifiers = new BlocklistIdentifiers(sdkConfiguration);
        this.betaFeatures = new BetaFeatures(sdkConfiguration);
        this.actorTokens = new ActorTokens(sdkConfiguration);
        this.domains = new Domains(sdkConfiguration);
        this.instanceSettings = new InstanceSettings(sdkConfiguration);
        this.webhooks = new Webhooks(sdkConfiguration);
        this.jwtTemplates = new JwtTemplates(sdkConfiguration);
        this.machines = new Machines(sdkConfiguration);
        this.organizations = new Organizations(sdkConfiguration);
        this.organizationMemberships = new OrganizationMemberships(sdkConfiguration);
        this.organizationDomains = new OrganizationDomains(sdkConfiguration);
        this.proxyChecks = new ProxyChecks(sdkConfiguration);
        this.redirectUrls = new RedirectUrls(sdkConfiguration);
        this.signInTokens = new SignInTokens(sdkConfiguration);
        this.signUps = new SignUps(sdkConfiguration);
        this.oauthApplications = new OauthApplications(sdkConfiguration);
        this.samlConnections = new SamlConnections(sdkConfiguration);
        this.testingTokens = new TestingTokens(sdkConfiguration);
        this.waitlistEntries = new WaitlistEntries(sdkConfiguration);
        this.experimentalAccountlessApplications = new ExperimentalAccountlessApplications(sdkConfiguration);
        this.commerce = new Commerce(sdkConfiguration);
        this.m2m = new M2m(sdkConfiguration);
        this.oauthAccessTokens = new OauthAccessTokens(sdkConfiguration);
        Hook.SdkInitData data = this.sdkConfiguration.hooks().sdkInit(new Hook.SdkInitData(this.sdkConfiguration.resolvedServerUrl(), this.sdkConfiguration.client()));
        this.sdkConfiguration.setServerUrl(data.baseUrl());
        this.sdkConfiguration.setClient(data.client());
    }

    public static class Builder {
        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();
        private String serverUrl;
        private String server;

        private Builder() {
        }

        public Builder client(HTTPClient client) {
            this.sdkConfiguration.setClient(client);
            return this;
        }

        public Builder bearerAuth(String bearerAuth) {
            this.sdkConfiguration.setSecuritySource(SecuritySource.of(Security.builder().bearerAuth(bearerAuth).build()));
            return this;
        }

        public Builder securitySource(SecuritySource securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.sdkConfiguration.setSecuritySource(securitySource);
            return this;
        }

        public Builder serverURL(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder serverIndex(int serverIdx) {
            this.sdkConfiguration.setServerIdx(serverIdx);
            this.serverUrl = SERVERS[serverIdx];
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.setRetryConfig(Optional.of(retryConfig));
            return this;
        }

        public Builder enableHTTPDebugLogging(boolean enabled) {
            this.sdkConfiguration.client().enableDebugLogging(enabled);
            return this;
        }

        Builder _hooks(Hooks hooks) {
            this.sdkConfiguration.setHooks(hooks);
            return this;
        }

        Builder _hooks(Consumer<? super Hooks> consumer) {
            consumer.accept(this.sdkConfiguration.hooks());
            return this;
        }

        public Clerk build() {
            if (this.serverUrl == null || this.serverUrl.isBlank()) {
                this.serverUrl = SERVERS[0];
                this.sdkConfiguration.setServerIdx(0);
            }
            this.sdkConfiguration.setServerUrl(this.serverUrl);
            return new Clerk(this.sdkConfiguration);
        }
    }
}

