/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.AddDomainRequestBody;
import com.clerk.backend_api.models.operations.AddDomainRequestBuilder;
import com.clerk.backend_api.models.operations.AddDomainResponse;
import com.clerk.backend_api.models.operations.DeleteDomainRequest;
import com.clerk.backend_api.models.operations.DeleteDomainRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteDomainResponse;
import com.clerk.backend_api.models.operations.ListDomainsRequestBuilder;
import com.clerk.backend_api.models.operations.ListDomainsResponse;
import com.clerk.backend_api.models.operations.UpdateDomainRequest;
import com.clerk.backend_api.models.operations.UpdateDomainRequestBody;
import com.clerk.backend_api.models.operations.UpdateDomainRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateDomainResponse;
import com.clerk.backend_api.operations.AddDomain;
import com.clerk.backend_api.operations.DeleteDomain;
import com.clerk.backend_api.operations.ListDomains;
import com.clerk.backend_api.operations.UpdateDomain;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class Domains {
    private final SDKConfiguration sdkConfiguration;

    Domains(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListDomainsRequestBuilder list() {
        return new ListDomainsRequestBuilder(this.sdkConfiguration);
    }

    public ListDomainsResponse listDirect() throws Exception {
        return this.list(Optional.empty());
    }

    public ListDomainsResponse list(Optional<Options> options) throws Exception {
        ListDomains.Sync operation = new ListDomains.Sync(this.sdkConfiguration, options);
        return (ListDomainsResponse)operation.handleResponse(operation.doRequest());
    }

    public AddDomainRequestBuilder add() {
        return new AddDomainRequestBuilder(this.sdkConfiguration);
    }

    public AddDomainResponse addDirect() throws Exception {
        return this.add(Optional.empty(), Optional.empty());
    }

    public AddDomainResponse add(Optional<? extends AddDomainRequestBody> request, Optional<Options> options) throws Exception {
        AddDomain.Sync operation = new AddDomain.Sync(this.sdkConfiguration, options);
        return (AddDomainResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteDomainRequestBuilder delete() {
        return new DeleteDomainRequestBuilder(this.sdkConfiguration);
    }

    public DeleteDomainResponse delete(String domainId) throws Exception {
        return this.delete(domainId, Optional.empty());
    }

    public DeleteDomainResponse delete(String domainId, Optional<Options> options) throws Exception {
        DeleteDomainRequest request = DeleteDomainRequest.builder().domainId(domainId).build();
        DeleteDomain.Sync operation = new DeleteDomain.Sync(this.sdkConfiguration, options);
        return (DeleteDomainResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateDomainRequestBuilder update() {
        return new UpdateDomainRequestBuilder(this.sdkConfiguration);
    }

    public UpdateDomainResponse update(String domainId, UpdateDomainRequestBody requestBody) throws Exception {
        return this.update(domainId, requestBody, Optional.empty());
    }

    public UpdateDomainResponse update(String domainId, UpdateDomainRequestBody requestBody, Optional<Options> options) throws Exception {
        UpdateDomainRequest request = UpdateDomainRequest.builder().domainId(domainId).requestBody(requestBody).build();
        UpdateDomain.Sync operation = new UpdateDomain.Sync(this.sdkConfiguration, options);
        return (UpdateDomainResponse)operation.handleResponse(operation.doRequest(request));
    }
}

