/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateEmailAddressRequestBody;
import com.clerk.backend_api.models.operations.CreateEmailAddressRequestBuilder;
import com.clerk.backend_api.models.operations.CreateEmailAddressResponse;
import com.clerk.backend_api.models.operations.DeleteEmailAddressRequest;
import com.clerk.backend_api.models.operations.DeleteEmailAddressRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteEmailAddressResponse;
import com.clerk.backend_api.models.operations.GetEmailAddressRequest;
import com.clerk.backend_api.models.operations.GetEmailAddressRequestBuilder;
import com.clerk.backend_api.models.operations.GetEmailAddressResponse;
import com.clerk.backend_api.models.operations.UpdateEmailAddressRequest;
import com.clerk.backend_api.models.operations.UpdateEmailAddressRequestBody;
import com.clerk.backend_api.models.operations.UpdateEmailAddressRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateEmailAddressResponse;
import com.clerk.backend_api.operations.CreateEmailAddress;
import com.clerk.backend_api.operations.DeleteEmailAddress;
import com.clerk.backend_api.operations.GetEmailAddress;
import com.clerk.backend_api.operations.UpdateEmailAddress;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class EmailAddresses {
    private final SDKConfiguration sdkConfiguration;

    EmailAddresses(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateEmailAddressRequestBuilder create() {
        return new CreateEmailAddressRequestBuilder(this.sdkConfiguration);
    }

    public CreateEmailAddressResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateEmailAddressResponse create(Optional<? extends CreateEmailAddressRequestBody> request, Optional<Options> options) throws Exception {
        CreateEmailAddress.Sync operation = new CreateEmailAddress.Sync(this.sdkConfiguration, options);
        return (CreateEmailAddressResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetEmailAddressRequestBuilder get() {
        return new GetEmailAddressRequestBuilder(this.sdkConfiguration);
    }

    public GetEmailAddressResponse get(String emailAddressId) throws Exception {
        return this.get(emailAddressId, Optional.empty());
    }

    public GetEmailAddressResponse get(String emailAddressId, Optional<Options> options) throws Exception {
        GetEmailAddressRequest request = GetEmailAddressRequest.builder().emailAddressId(emailAddressId).build();
        GetEmailAddress.Sync operation = new GetEmailAddress.Sync(this.sdkConfiguration, options);
        return (GetEmailAddressResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteEmailAddressRequestBuilder delete() {
        return new DeleteEmailAddressRequestBuilder(this.sdkConfiguration);
    }

    public DeleteEmailAddressResponse delete(String emailAddressId) throws Exception {
        return this.delete(emailAddressId, Optional.empty());
    }

    public DeleteEmailAddressResponse delete(String emailAddressId, Optional<Options> options) throws Exception {
        DeleteEmailAddressRequest request = DeleteEmailAddressRequest.builder().emailAddressId(emailAddressId).build();
        DeleteEmailAddress.Sync operation = new DeleteEmailAddress.Sync(this.sdkConfiguration, options);
        return (DeleteEmailAddressResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateEmailAddressRequestBuilder update() {
        return new UpdateEmailAddressRequestBuilder(this.sdkConfiguration);
    }

    public UpdateEmailAddressResponse update(String emailAddressId) throws Exception {
        return this.update(emailAddressId, Optional.empty(), Optional.empty());
    }

    public UpdateEmailAddressResponse update(String emailAddressId, Optional<? extends UpdateEmailAddressRequestBody> requestBody, Optional<Options> options) throws Exception {
        UpdateEmailAddressRequest request = UpdateEmailAddressRequest.builder().emailAddressId(emailAddressId).requestBody(requestBody).build();
        UpdateEmailAddress.Sync operation = new UpdateEmailAddress.Sync(this.sdkConfiguration, options);
        return (UpdateEmailAddressResponse)operation.handleResponse(operation.doRequest(request));
    }
}

