/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateBulkInvitationsRequestBuilder;
import com.clerk.backend_api.models.operations.CreateBulkInvitationsResponse;
import com.clerk.backend_api.models.operations.CreateInvitationRequestBody;
import com.clerk.backend_api.models.operations.CreateInvitationRequestBuilder;
import com.clerk.backend_api.models.operations.CreateInvitationResponse;
import com.clerk.backend_api.models.operations.ListInvitationsRequest;
import com.clerk.backend_api.models.operations.ListInvitationsRequestBuilder;
import com.clerk.backend_api.models.operations.ListInvitationsResponse;
import com.clerk.backend_api.models.operations.RequestBody;
import com.clerk.backend_api.models.operations.RevokeInvitationRequest;
import com.clerk.backend_api.models.operations.RevokeInvitationRequestBuilder;
import com.clerk.backend_api.models.operations.RevokeInvitationResponse;
import com.clerk.backend_api.operations.CreateBulkInvitations;
import com.clerk.backend_api.operations.CreateInvitation;
import com.clerk.backend_api.operations.ListInvitations;
import com.clerk.backend_api.operations.RevokeInvitation;
import com.clerk.backend_api.utils.Options;
import java.util.List;
import java.util.Optional;

public class Invitations {
    private final SDKConfiguration sdkConfiguration;

    Invitations(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateInvitationRequestBuilder create() {
        return new CreateInvitationRequestBuilder(this.sdkConfiguration);
    }

    public CreateInvitationResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateInvitationResponse create(Optional<? extends CreateInvitationRequestBody> request, Optional<Options> options) throws Exception {
        CreateInvitation.Sync operation = new CreateInvitation.Sync(this.sdkConfiguration, options);
        return (CreateInvitationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public ListInvitationsRequestBuilder list() {
        return new ListInvitationsRequestBuilder(this.sdkConfiguration);
    }

    public ListInvitationsResponse list(ListInvitationsRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    public ListInvitationsResponse list(ListInvitationsRequest request, Optional<Options> options) throws Exception {
        ListInvitations.Sync operation = new ListInvitations.Sync(this.sdkConfiguration, options);
        return (ListInvitationsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateBulkInvitationsRequestBuilder bulkCreate() {
        return new CreateBulkInvitationsRequestBuilder(this.sdkConfiguration);
    }

    public CreateBulkInvitationsResponse bulkCreateDirect() throws Exception {
        return this.bulkCreate(Optional.empty(), Optional.empty());
    }

    public CreateBulkInvitationsResponse bulkCreate(Optional<? extends List<RequestBody>> request, Optional<Options> options) throws Exception {
        CreateBulkInvitations.Sync operation = new CreateBulkInvitations.Sync(this.sdkConfiguration, options);
        return (CreateBulkInvitationsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public RevokeInvitationRequestBuilder revoke() {
        return new RevokeInvitationRequestBuilder(this.sdkConfiguration);
    }

    public RevokeInvitationResponse revoke(String invitationId) throws Exception {
        return this.revoke(invitationId, Optional.empty());
    }

    public RevokeInvitationResponse revoke(String invitationId, Optional<Options> options) throws Exception {
        RevokeInvitationRequest request = RevokeInvitationRequest.builder().invitationId(invitationId).build();
        RevokeInvitation.Sync operation = new RevokeInvitation.Sync(this.sdkConfiguration, options);
        return (RevokeInvitationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

