/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateJWTTemplateRequestBody;
import com.clerk.backend_api.models.operations.CreateJWTTemplateRequestBuilder;
import com.clerk.backend_api.models.operations.CreateJWTTemplateResponse;
import com.clerk.backend_api.models.operations.DeleteJWTTemplateRequest;
import com.clerk.backend_api.models.operations.DeleteJWTTemplateRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteJWTTemplateResponse;
import com.clerk.backend_api.models.operations.GetJWTTemplateRequest;
import com.clerk.backend_api.models.operations.GetJWTTemplateRequestBuilder;
import com.clerk.backend_api.models.operations.GetJWTTemplateResponse;
import com.clerk.backend_api.models.operations.ListJWTTemplatesRequest;
import com.clerk.backend_api.models.operations.ListJWTTemplatesRequestBuilder;
import com.clerk.backend_api.models.operations.ListJWTTemplatesResponse;
import com.clerk.backend_api.models.operations.UpdateJWTTemplateRequest;
import com.clerk.backend_api.models.operations.UpdateJWTTemplateRequestBody;
import com.clerk.backend_api.models.operations.UpdateJWTTemplateRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateJWTTemplateResponse;
import com.clerk.backend_api.operations.CreateJWTTemplate;
import com.clerk.backend_api.operations.DeleteJWTTemplate;
import com.clerk.backend_api.operations.GetJWTTemplate;
import com.clerk.backend_api.operations.ListJWTTemplates;
import com.clerk.backend_api.operations.UpdateJWTTemplate;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class JwtTemplates {
    private final SDKConfiguration sdkConfiguration;

    JwtTemplates(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListJWTTemplatesRequestBuilder list() {
        return new ListJWTTemplatesRequestBuilder(this.sdkConfiguration);
    }

    public ListJWTTemplatesResponse listDirect() throws Exception {
        return this.list(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ListJWTTemplatesResponse list(Optional<Boolean> paginated, Optional<Long> limit, Optional<Long> offset, Optional<Options> options) throws Exception {
        ListJWTTemplatesRequest request = ListJWTTemplatesRequest.builder().paginated(paginated).limit(limit).offset(offset).build();
        ListJWTTemplates.Sync operation = new ListJWTTemplates.Sync(this.sdkConfiguration, options);
        return (ListJWTTemplatesResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateJWTTemplateRequestBuilder create() {
        return new CreateJWTTemplateRequestBuilder(this.sdkConfiguration);
    }

    public CreateJWTTemplateResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateJWTTemplateResponse create(Optional<? extends CreateJWTTemplateRequestBody> request, Optional<Options> options) throws Exception {
        CreateJWTTemplate.Sync operation = new CreateJWTTemplate.Sync(this.sdkConfiguration, options);
        return (CreateJWTTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetJWTTemplateRequestBuilder get() {
        return new GetJWTTemplateRequestBuilder(this.sdkConfiguration);
    }

    public GetJWTTemplateResponse get(String templateId) throws Exception {
        return this.get(templateId, Optional.empty());
    }

    public GetJWTTemplateResponse get(String templateId, Optional<Options> options) throws Exception {
        GetJWTTemplateRequest request = GetJWTTemplateRequest.builder().templateId(templateId).build();
        GetJWTTemplate.Sync operation = new GetJWTTemplate.Sync(this.sdkConfiguration, options);
        return (GetJWTTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateJWTTemplateRequestBuilder update() {
        return new UpdateJWTTemplateRequestBuilder(this.sdkConfiguration);
    }

    public UpdateJWTTemplateResponse update(String templateId) throws Exception {
        return this.update(templateId, Optional.empty(), Optional.empty());
    }

    public UpdateJWTTemplateResponse update(String templateId, Optional<? extends UpdateJWTTemplateRequestBody> requestBody, Optional<Options> options) throws Exception {
        UpdateJWTTemplateRequest request = UpdateJWTTemplateRequest.builder().templateId(templateId).requestBody(requestBody).build();
        UpdateJWTTemplate.Sync operation = new UpdateJWTTemplate.Sync(this.sdkConfiguration, options);
        return (UpdateJWTTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteJWTTemplateRequestBuilder delete() {
        return new DeleteJWTTemplateRequestBuilder(this.sdkConfiguration);
    }

    public DeleteJWTTemplateResponse delete(String templateId) throws Exception {
        return this.delete(templateId, Optional.empty());
    }

    public DeleteJWTTemplateResponse delete(String templateId, Optional<Options> options) throws Exception {
        DeleteJWTTemplateRequest request = DeleteJWTTemplateRequest.builder().templateId(templateId).build();
        DeleteJWTTemplate.Sync operation = new DeleteJWTTemplate.Sync(this.sdkConfiguration, options);
        return (DeleteJWTTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }
}

