/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateM2MTokenRequestBody;
import com.clerk.backend_api.models.operations.CreateM2MTokenRequestBuilder;
import com.clerk.backend_api.models.operations.CreateM2MTokenResponse;
import com.clerk.backend_api.models.operations.GetM2MTokensRequest;
import com.clerk.backend_api.models.operations.GetM2MTokensRequestBuilder;
import com.clerk.backend_api.models.operations.GetM2MTokensResponse;
import com.clerk.backend_api.models.operations.RevokeM2MTokenRequest;
import com.clerk.backend_api.models.operations.RevokeM2MTokenRequestBody;
import com.clerk.backend_api.models.operations.RevokeM2MTokenRequestBuilder;
import com.clerk.backend_api.models.operations.RevokeM2MTokenResponse;
import com.clerk.backend_api.models.operations.VerifyM2MTokenRequestBody;
import com.clerk.backend_api.models.operations.VerifyM2MTokenRequestBuilder;
import com.clerk.backend_api.models.operations.VerifyM2MTokenResponse;
import com.clerk.backend_api.operations.CreateM2MToken;
import com.clerk.backend_api.operations.GetM2MTokens;
import com.clerk.backend_api.operations.RevokeM2MToken;
import com.clerk.backend_api.operations.VerifyM2MToken;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class M2m {
    private final SDKConfiguration sdkConfiguration;

    M2m(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateM2MTokenRequestBuilder createToken() {
        return new CreateM2MTokenRequestBuilder(this.sdkConfiguration);
    }

    public CreateM2MTokenResponse createToken(CreateM2MTokenRequestBody request) throws Exception {
        return this.createToken(request, Optional.empty());
    }

    public CreateM2MTokenResponse createToken(CreateM2MTokenRequestBody request, Optional<Options> options) throws Exception {
        CreateM2MToken.Sync operation = new CreateM2MToken.Sync(this.sdkConfiguration, options);
        return (CreateM2MTokenResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetM2MTokensRequestBuilder listTokens() {
        return new GetM2MTokensRequestBuilder(this.sdkConfiguration);
    }

    public GetM2MTokensResponse listTokens(GetM2MTokensRequest request) throws Exception {
        return this.listTokens(request, Optional.empty());
    }

    public GetM2MTokensResponse listTokens(GetM2MTokensRequest request, Optional<Options> options) throws Exception {
        GetM2MTokens.Sync operation = new GetM2MTokens.Sync(this.sdkConfiguration, options);
        return (GetM2MTokensResponse)operation.handleResponse(operation.doRequest(request));
    }

    public RevokeM2MTokenRequestBuilder revokeToken() {
        return new RevokeM2MTokenRequestBuilder(this.sdkConfiguration);
    }

    public RevokeM2MTokenResponse revokeToken(String m2mTokenId, RevokeM2MTokenRequestBody requestBody) throws Exception {
        return this.revokeToken(m2mTokenId, requestBody, Optional.empty());
    }

    public RevokeM2MTokenResponse revokeToken(String m2mTokenId, RevokeM2MTokenRequestBody requestBody, Optional<Options> options) throws Exception {
        RevokeM2MTokenRequest request = RevokeM2MTokenRequest.builder().m2mTokenId(m2mTokenId).requestBody(requestBody).build();
        RevokeM2MToken.Sync operation = new RevokeM2MToken.Sync(this.sdkConfiguration, options);
        return (RevokeM2MTokenResponse)operation.handleResponse(operation.doRequest(request));
    }

    public VerifyM2MTokenRequestBuilder verifyToken() {
        return new VerifyM2MTokenRequestBuilder(this.sdkConfiguration);
    }

    public VerifyM2MTokenResponse verifyToken(VerifyM2MTokenRequestBody request) throws Exception {
        return this.verifyToken(request, Optional.empty());
    }

    public VerifyM2MTokenResponse verifyToken(VerifyM2MTokenRequestBody request, Optional<Options> options) throws Exception {
        VerifyM2MToken.Sync operation = new VerifyM2MToken.Sync(this.sdkConfiguration, options);
        return (VerifyM2MTokenResponse)operation.handleResponse(operation.doRequest(request));
    }
}

