/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateMachineRequestBody;
import com.clerk.backend_api.models.operations.CreateMachineRequestBuilder;
import com.clerk.backend_api.models.operations.CreateMachineResponse;
import com.clerk.backend_api.models.operations.CreateMachineScopeRequest;
import com.clerk.backend_api.models.operations.CreateMachineScopeRequestBody;
import com.clerk.backend_api.models.operations.CreateMachineScopeRequestBuilder;
import com.clerk.backend_api.models.operations.CreateMachineScopeResponse;
import com.clerk.backend_api.models.operations.DeleteMachineRequest;
import com.clerk.backend_api.models.operations.DeleteMachineRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteMachineResponse;
import com.clerk.backend_api.models.operations.DeleteMachineScopeRequest;
import com.clerk.backend_api.models.operations.DeleteMachineScopeRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteMachineScopeResponse;
import com.clerk.backend_api.models.operations.GetMachineRequest;
import com.clerk.backend_api.models.operations.GetMachineRequestBuilder;
import com.clerk.backend_api.models.operations.GetMachineResponse;
import com.clerk.backend_api.models.operations.GetMachineSecretKeyRequest;
import com.clerk.backend_api.models.operations.GetMachineSecretKeyRequestBuilder;
import com.clerk.backend_api.models.operations.GetMachineSecretKeyResponse;
import com.clerk.backend_api.models.operations.ListMachinesRequest;
import com.clerk.backend_api.models.operations.ListMachinesRequestBuilder;
import com.clerk.backend_api.models.operations.ListMachinesResponse;
import com.clerk.backend_api.models.operations.UpdateMachineRequest;
import com.clerk.backend_api.models.operations.UpdateMachineRequestBody;
import com.clerk.backend_api.models.operations.UpdateMachineRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateMachineResponse;
import com.clerk.backend_api.operations.CreateMachine;
import com.clerk.backend_api.operations.CreateMachineScope;
import com.clerk.backend_api.operations.DeleteMachine;
import com.clerk.backend_api.operations.DeleteMachineScope;
import com.clerk.backend_api.operations.GetMachine;
import com.clerk.backend_api.operations.GetMachineSecretKey;
import com.clerk.backend_api.operations.ListMachines;
import com.clerk.backend_api.operations.UpdateMachine;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class Machines {
    private final SDKConfiguration sdkConfiguration;

    Machines(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListMachinesRequestBuilder list() {
        return new ListMachinesRequestBuilder(this.sdkConfiguration);
    }

    public ListMachinesResponse listDirect() throws Exception {
        return this.list(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ListMachinesResponse list(Optional<Long> limit, Optional<Long> offset, Optional<String> query, Optional<String> orderBy, Optional<Options> options) throws Exception {
        ListMachinesRequest request = ListMachinesRequest.builder().limit(limit).offset(offset).query(query).orderBy(orderBy).build();
        ListMachines.Sync operation = new ListMachines.Sync(this.sdkConfiguration, options);
        return (ListMachinesResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateMachineRequestBuilder create() {
        return new CreateMachineRequestBuilder(this.sdkConfiguration);
    }

    public CreateMachineResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateMachineResponse create(Optional<? extends CreateMachineRequestBody> request, Optional<Options> options) throws Exception {
        CreateMachine.Sync operation = new CreateMachine.Sync(this.sdkConfiguration, options);
        return (CreateMachineResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetMachineRequestBuilder get() {
        return new GetMachineRequestBuilder(this.sdkConfiguration);
    }

    public GetMachineResponse get(String machineId) throws Exception {
        return this.get(machineId, Optional.empty());
    }

    public GetMachineResponse get(String machineId, Optional<Options> options) throws Exception {
        GetMachineRequest request = GetMachineRequest.builder().machineId(machineId).build();
        GetMachine.Sync operation = new GetMachine.Sync(this.sdkConfiguration, options);
        return (GetMachineResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateMachineRequestBuilder update() {
        return new UpdateMachineRequestBuilder(this.sdkConfiguration);
    }

    public UpdateMachineResponse update(String machineId) throws Exception {
        return this.update(machineId, Optional.empty(), Optional.empty());
    }

    public UpdateMachineResponse update(String machineId, Optional<? extends UpdateMachineRequestBody> requestBody, Optional<Options> options) throws Exception {
        UpdateMachineRequest request = UpdateMachineRequest.builder().machineId(machineId).requestBody(requestBody).build();
        UpdateMachine.Sync operation = new UpdateMachine.Sync(this.sdkConfiguration, options);
        return (UpdateMachineResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteMachineRequestBuilder delete() {
        return new DeleteMachineRequestBuilder(this.sdkConfiguration);
    }

    public DeleteMachineResponse delete(String machineId) throws Exception {
        return this.delete(machineId, Optional.empty());
    }

    public DeleteMachineResponse delete(String machineId, Optional<Options> options) throws Exception {
        DeleteMachineRequest request = DeleteMachineRequest.builder().machineId(machineId).build();
        DeleteMachine.Sync operation = new DeleteMachine.Sync(this.sdkConfiguration, options);
        return (DeleteMachineResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetMachineSecretKeyRequestBuilder getSecretKey() {
        return new GetMachineSecretKeyRequestBuilder(this.sdkConfiguration);
    }

    public GetMachineSecretKeyResponse getSecretKey(String machineId) throws Exception {
        return this.getSecretKey(machineId, Optional.empty());
    }

    public GetMachineSecretKeyResponse getSecretKey(String machineId, Optional<Options> options) throws Exception {
        GetMachineSecretKeyRequest request = GetMachineSecretKeyRequest.builder().machineId(machineId).build();
        GetMachineSecretKey.Sync operation = new GetMachineSecretKey.Sync(this.sdkConfiguration, options);
        return (GetMachineSecretKeyResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateMachineScopeRequestBuilder createScope() {
        return new CreateMachineScopeRequestBuilder(this.sdkConfiguration);
    }

    public CreateMachineScopeResponse createScope(String machineId) throws Exception {
        return this.createScope(machineId, Optional.empty(), Optional.empty());
    }

    public CreateMachineScopeResponse createScope(String machineId, Optional<? extends CreateMachineScopeRequestBody> requestBody, Optional<Options> options) throws Exception {
        CreateMachineScopeRequest request = CreateMachineScopeRequest.builder().machineId(machineId).requestBody(requestBody).build();
        CreateMachineScope.Sync operation = new CreateMachineScope.Sync(this.sdkConfiguration, options);
        return (CreateMachineScopeResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteMachineScopeRequestBuilder deleteScope() {
        return new DeleteMachineScopeRequestBuilder(this.sdkConfiguration);
    }

    public DeleteMachineScopeResponse deleteScope(String machineId, String otherMachineId) throws Exception {
        return this.deleteScope(machineId, otherMachineId, Optional.empty());
    }

    public DeleteMachineScopeResponse deleteScope(String machineId, String otherMachineId, Optional<Options> options) throws Exception {
        DeleteMachineScopeRequest request = DeleteMachineScopeRequest.builder().machineId(machineId).otherMachineId(otherMachineId).build();
        DeleteMachineScope.Sync operation = new DeleteMachineScope.Sync(this.sdkConfiguration, options);
        return (DeleteMachineScopeResponse)operation.handleResponse(operation.doRequest(request));
    }
}

