/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateOAuthApplicationRequestBody;
import com.clerk.backend_api.models.operations.CreateOAuthApplicationRequestBuilder;
import com.clerk.backend_api.models.operations.CreateOAuthApplicationResponse;
import com.clerk.backend_api.models.operations.DeleteOAuthApplicationRequest;
import com.clerk.backend_api.models.operations.DeleteOAuthApplicationRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteOAuthApplicationResponse;
import com.clerk.backend_api.models.operations.GetOAuthApplicationRequest;
import com.clerk.backend_api.models.operations.GetOAuthApplicationRequestBuilder;
import com.clerk.backend_api.models.operations.GetOAuthApplicationResponse;
import com.clerk.backend_api.models.operations.ListOAuthApplicationsRequest;
import com.clerk.backend_api.models.operations.ListOAuthApplicationsRequestBuilder;
import com.clerk.backend_api.models.operations.ListOAuthApplicationsResponse;
import com.clerk.backend_api.models.operations.RotateOAuthApplicationSecretRequest;
import com.clerk.backend_api.models.operations.RotateOAuthApplicationSecretRequestBuilder;
import com.clerk.backend_api.models.operations.RotateOAuthApplicationSecretResponse;
import com.clerk.backend_api.models.operations.UpdateOAuthApplicationRequest;
import com.clerk.backend_api.models.operations.UpdateOAuthApplicationRequestBody;
import com.clerk.backend_api.models.operations.UpdateOAuthApplicationRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateOAuthApplicationResponse;
import com.clerk.backend_api.operations.CreateOAuthApplication;
import com.clerk.backend_api.operations.DeleteOAuthApplication;
import com.clerk.backend_api.operations.GetOAuthApplication;
import com.clerk.backend_api.operations.ListOAuthApplications;
import com.clerk.backend_api.operations.RotateOAuthApplicationSecret;
import com.clerk.backend_api.operations.UpdateOAuthApplication;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class OauthApplications {
    private final SDKConfiguration sdkConfiguration;

    OauthApplications(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListOAuthApplicationsRequestBuilder list() {
        return new ListOAuthApplicationsRequestBuilder(this.sdkConfiguration);
    }

    public ListOAuthApplicationsResponse listDirect() throws Exception {
        return this.list(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ListOAuthApplicationsResponse list(Optional<Long> limit, Optional<Long> offset, Optional<String> orderBy, Optional<String> nameQuery, Optional<Options> options) throws Exception {
        ListOAuthApplicationsRequest request = ListOAuthApplicationsRequest.builder().limit(limit).offset(offset).orderBy(orderBy).nameQuery(nameQuery).build();
        ListOAuthApplications.Sync operation = new ListOAuthApplications.Sync(this.sdkConfiguration, options);
        return (ListOAuthApplicationsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateOAuthApplicationRequestBuilder create() {
        return new CreateOAuthApplicationRequestBuilder(this.sdkConfiguration);
    }

    public CreateOAuthApplicationResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateOAuthApplicationResponse create(Optional<? extends CreateOAuthApplicationRequestBody> request, Optional<Options> options) throws Exception {
        CreateOAuthApplication.Sync operation = new CreateOAuthApplication.Sync(this.sdkConfiguration, options);
        return (CreateOAuthApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetOAuthApplicationRequestBuilder get() {
        return new GetOAuthApplicationRequestBuilder(this.sdkConfiguration);
    }

    public GetOAuthApplicationResponse get(String oauthApplicationId) throws Exception {
        return this.get(oauthApplicationId, Optional.empty());
    }

    public GetOAuthApplicationResponse get(String oauthApplicationId, Optional<Options> options) throws Exception {
        GetOAuthApplicationRequest request = GetOAuthApplicationRequest.builder().oauthApplicationId(oauthApplicationId).build();
        GetOAuthApplication.Sync operation = new GetOAuthApplication.Sync(this.sdkConfiguration, options);
        return (GetOAuthApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateOAuthApplicationRequestBuilder update() {
        return new UpdateOAuthApplicationRequestBuilder(this.sdkConfiguration);
    }

    public UpdateOAuthApplicationResponse update(String oauthApplicationId, UpdateOAuthApplicationRequestBody requestBody) throws Exception {
        return this.update(oauthApplicationId, requestBody, Optional.empty());
    }

    public UpdateOAuthApplicationResponse update(String oauthApplicationId, UpdateOAuthApplicationRequestBody requestBody, Optional<Options> options) throws Exception {
        UpdateOAuthApplicationRequest request = UpdateOAuthApplicationRequest.builder().oauthApplicationId(oauthApplicationId).requestBody(requestBody).build();
        UpdateOAuthApplication.Sync operation = new UpdateOAuthApplication.Sync(this.sdkConfiguration, options);
        return (UpdateOAuthApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteOAuthApplicationRequestBuilder delete() {
        return new DeleteOAuthApplicationRequestBuilder(this.sdkConfiguration);
    }

    public DeleteOAuthApplicationResponse delete(String oauthApplicationId) throws Exception {
        return this.delete(oauthApplicationId, Optional.empty());
    }

    public DeleteOAuthApplicationResponse delete(String oauthApplicationId, Optional<Options> options) throws Exception {
        DeleteOAuthApplicationRequest request = DeleteOAuthApplicationRequest.builder().oauthApplicationId(oauthApplicationId).build();
        DeleteOAuthApplication.Sync operation = new DeleteOAuthApplication.Sync(this.sdkConfiguration, options);
        return (DeleteOAuthApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public RotateOAuthApplicationSecretRequestBuilder rotateSecret() {
        return new RotateOAuthApplicationSecretRequestBuilder(this.sdkConfiguration);
    }

    public RotateOAuthApplicationSecretResponse rotateSecret(String oauthApplicationId) throws Exception {
        return this.rotateSecret(oauthApplicationId, Optional.empty());
    }

    public RotateOAuthApplicationSecretResponse rotateSecret(String oauthApplicationId, Optional<Options> options) throws Exception {
        RotateOAuthApplicationSecretRequest request = RotateOAuthApplicationSecretRequest.builder().oauthApplicationId(oauthApplicationId).build();
        RotateOAuthApplicationSecret.Sync operation = new RotateOAuthApplicationSecret.Sync(this.sdkConfiguration, options);
        return (RotateOAuthApplicationSecretResponse)operation.handleResponse(operation.doRequest(request));
    }
}

