/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequestBody;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequestBuilder;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainResponse;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainResponse;
import com.clerk.backend_api.models.operations.ListAllOrganizationDomainsRequest;
import com.clerk.backend_api.models.operations.ListAllOrganizationDomainsRequestBuilder;
import com.clerk.backend_api.models.operations.ListAllOrganizationDomainsResponse;
import com.clerk.backend_api.models.operations.ListOrganizationDomainsRequest;
import com.clerk.backend_api.models.operations.ListOrganizationDomainsRequestBuilder;
import com.clerk.backend_api.models.operations.ListOrganizationDomainsResponse;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainResponse;
import com.clerk.backend_api.operations.CreateOrganizationDomain;
import com.clerk.backend_api.operations.DeleteOrganizationDomain;
import com.clerk.backend_api.operations.ListAllOrganizationDomains;
import com.clerk.backend_api.operations.ListOrganizationDomains;
import com.clerk.backend_api.operations.UpdateOrganizationDomain;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class OrganizationDomains {
    private final SDKConfiguration sdkConfiguration;

    OrganizationDomains(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateOrganizationDomainRequestBuilder create() {
        return new CreateOrganizationDomainRequestBuilder(this.sdkConfiguration);
    }

    public CreateOrganizationDomainResponse create(String organizationId, CreateOrganizationDomainRequestBody requestBody) throws Exception {
        return this.create(organizationId, requestBody, Optional.empty());
    }

    public CreateOrganizationDomainResponse create(String organizationId, CreateOrganizationDomainRequestBody requestBody, Optional<Options> options) throws Exception {
        CreateOrganizationDomainRequest request = CreateOrganizationDomainRequest.builder().organizationId(organizationId).requestBody(requestBody).build();
        CreateOrganizationDomain.Sync operation = new CreateOrganizationDomain.Sync(this.sdkConfiguration, options);
        return (CreateOrganizationDomainResponse)operation.handleResponse(operation.doRequest(request));
    }

    public ListOrganizationDomainsRequestBuilder list() {
        return new ListOrganizationDomainsRequestBuilder(this.sdkConfiguration);
    }

    public ListOrganizationDomainsResponse list(ListOrganizationDomainsRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    public ListOrganizationDomainsResponse list(ListOrganizationDomainsRequest request, Optional<Options> options) throws Exception {
        ListOrganizationDomains.Sync operation = new ListOrganizationDomains.Sync(this.sdkConfiguration, options);
        return (ListOrganizationDomainsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateOrganizationDomainRequestBuilder update() {
        return new UpdateOrganizationDomainRequestBuilder(this.sdkConfiguration);
    }

    public UpdateOrganizationDomainResponse update(String organizationId, String domainId, UpdateOrganizationDomainRequestBody requestBody) throws Exception {
        return this.update(organizationId, domainId, requestBody, Optional.empty());
    }

    public UpdateOrganizationDomainResponse update(String organizationId, String domainId, UpdateOrganizationDomainRequestBody requestBody, Optional<Options> options) throws Exception {
        UpdateOrganizationDomainRequest request = UpdateOrganizationDomainRequest.builder().organizationId(organizationId).domainId(domainId).requestBody(requestBody).build();
        UpdateOrganizationDomain.Sync operation = new UpdateOrganizationDomain.Sync(this.sdkConfiguration, options);
        return (UpdateOrganizationDomainResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteOrganizationDomainRequestBuilder delete() {
        return new DeleteOrganizationDomainRequestBuilder(this.sdkConfiguration);
    }

    public DeleteOrganizationDomainResponse delete(String organizationId, String domainId) throws Exception {
        return this.delete(organizationId, domainId, Optional.empty());
    }

    public DeleteOrganizationDomainResponse delete(String organizationId, String domainId, Optional<Options> options) throws Exception {
        DeleteOrganizationDomainRequest request = DeleteOrganizationDomainRequest.builder().organizationId(organizationId).domainId(domainId).build();
        DeleteOrganizationDomain.Sync operation = new DeleteOrganizationDomain.Sync(this.sdkConfiguration, options);
        return (DeleteOrganizationDomainResponse)operation.handleResponse(operation.doRequest(request));
    }

    public ListAllOrganizationDomainsRequestBuilder listAll() {
        return new ListAllOrganizationDomainsRequestBuilder(this.sdkConfiguration);
    }

    public ListAllOrganizationDomainsResponse listAll(ListAllOrganizationDomainsRequest request) throws Exception {
        return this.listAll(request, Optional.empty());
    }

    public ListAllOrganizationDomainsResponse listAll(ListAllOrganizationDomainsRequest request, Optional<Options> options) throws Exception {
        ListAllOrganizationDomains.Sync operation = new ListAllOrganizationDomains.Sync(this.sdkConfiguration, options);
        return (ListAllOrganizationDomainsResponse)operation.handleResponse(operation.doRequest(request));
    }
}

