/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateOrganizationMembershipRequest;
import com.clerk.backend_api.models.operations.CreateOrganizationMembershipRequestBody;
import com.clerk.backend_api.models.operations.CreateOrganizationMembershipRequestBuilder;
import com.clerk.backend_api.models.operations.CreateOrganizationMembershipResponse;
import com.clerk.backend_api.models.operations.DeleteOrganizationMembershipRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationMembershipRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteOrganizationMembershipResponse;
import com.clerk.backend_api.models.operations.ListOrganizationMembershipsRequest;
import com.clerk.backend_api.models.operations.ListOrganizationMembershipsRequestBuilder;
import com.clerk.backend_api.models.operations.ListOrganizationMembershipsResponse;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipMetadataRequest;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipMetadataRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipMetadataRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipMetadataResponse;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipRequest;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipResponse;
import com.clerk.backend_api.operations.CreateOrganizationMembership;
import com.clerk.backend_api.operations.DeleteOrganizationMembership;
import com.clerk.backend_api.operations.ListOrganizationMemberships;
import com.clerk.backend_api.operations.UpdateOrganizationMembership;
import com.clerk.backend_api.operations.UpdateOrganizationMembershipMetadata;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class OrganizationMemberships {
    private final SDKConfiguration sdkConfiguration;

    OrganizationMemberships(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateOrganizationMembershipRequestBuilder create() {
        return new CreateOrganizationMembershipRequestBuilder(this.sdkConfiguration);
    }

    public CreateOrganizationMembershipResponse create(String organizationId, CreateOrganizationMembershipRequestBody requestBody) throws Exception {
        return this.create(organizationId, requestBody, Optional.empty());
    }

    public CreateOrganizationMembershipResponse create(String organizationId, CreateOrganizationMembershipRequestBody requestBody, Optional<Options> options) throws Exception {
        CreateOrganizationMembershipRequest request = CreateOrganizationMembershipRequest.builder().organizationId(organizationId).requestBody(requestBody).build();
        CreateOrganizationMembership.Sync operation = new CreateOrganizationMembership.Sync(this.sdkConfiguration, options);
        return (CreateOrganizationMembershipResponse)operation.handleResponse(operation.doRequest(request));
    }

    public ListOrganizationMembershipsRequestBuilder list() {
        return new ListOrganizationMembershipsRequestBuilder(this.sdkConfiguration);
    }

    public ListOrganizationMembershipsResponse list(ListOrganizationMembershipsRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    public ListOrganizationMembershipsResponse list(ListOrganizationMembershipsRequest request, Optional<Options> options) throws Exception {
        ListOrganizationMemberships.Sync operation = new ListOrganizationMemberships.Sync(this.sdkConfiguration, options);
        return (ListOrganizationMembershipsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateOrganizationMembershipRequestBuilder update() {
        return new UpdateOrganizationMembershipRequestBuilder(this.sdkConfiguration);
    }

    public UpdateOrganizationMembershipResponse update(String organizationId, String userId, UpdateOrganizationMembershipRequestBody requestBody) throws Exception {
        return this.update(organizationId, userId, requestBody, Optional.empty());
    }

    public UpdateOrganizationMembershipResponse update(String organizationId, String userId, UpdateOrganizationMembershipRequestBody requestBody, Optional<Options> options) throws Exception {
        UpdateOrganizationMembershipRequest request = UpdateOrganizationMembershipRequest.builder().organizationId(organizationId).userId(userId).requestBody(requestBody).build();
        UpdateOrganizationMembership.Sync operation = new UpdateOrganizationMembership.Sync(this.sdkConfiguration, options);
        return (UpdateOrganizationMembershipResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteOrganizationMembershipRequestBuilder delete() {
        return new DeleteOrganizationMembershipRequestBuilder(this.sdkConfiguration);
    }

    public DeleteOrganizationMembershipResponse delete(String organizationId, String userId) throws Exception {
        return this.delete(organizationId, userId, Optional.empty());
    }

    public DeleteOrganizationMembershipResponse delete(String organizationId, String userId, Optional<Options> options) throws Exception {
        DeleteOrganizationMembershipRequest request = DeleteOrganizationMembershipRequest.builder().organizationId(organizationId).userId(userId).build();
        DeleteOrganizationMembership.Sync operation = new DeleteOrganizationMembership.Sync(this.sdkConfiguration, options);
        return (DeleteOrganizationMembershipResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateOrganizationMembershipMetadataRequestBuilder updateMetadata() {
        return new UpdateOrganizationMembershipMetadataRequestBuilder(this.sdkConfiguration);
    }

    public UpdateOrganizationMembershipMetadataResponse updateMetadata(String organizationId, String userId) throws Exception {
        return this.updateMetadata(organizationId, userId, Optional.empty(), Optional.empty());
    }

    public UpdateOrganizationMembershipMetadataResponse updateMetadata(String organizationId, String userId, Optional<? extends UpdateOrganizationMembershipMetadataRequestBody> requestBody, Optional<Options> options) throws Exception {
        UpdateOrganizationMembershipMetadataRequest request = UpdateOrganizationMembershipMetadataRequest.builder().organizationId(organizationId).userId(userId).requestBody(requestBody).build();
        UpdateOrganizationMembershipMetadata.Sync operation = new UpdateOrganizationMembershipMetadata.Sync(this.sdkConfiguration, options);
        return (UpdateOrganizationMembershipMetadataResponse)operation.handleResponse(operation.doRequest(request));
    }
}

