/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateOrganizationRequestBody;
import com.clerk.backend_api.models.operations.CreateOrganizationRequestBuilder;
import com.clerk.backend_api.models.operations.CreateOrganizationResponse;
import com.clerk.backend_api.models.operations.DeleteOrganizationLogoRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationLogoRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteOrganizationLogoResponse;
import com.clerk.backend_api.models.operations.DeleteOrganizationRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteOrganizationResponse;
import com.clerk.backend_api.models.operations.GetOrganizationBillingSubscriptionRequest;
import com.clerk.backend_api.models.operations.GetOrganizationBillingSubscriptionRequestBuilder;
import com.clerk.backend_api.models.operations.GetOrganizationBillingSubscriptionResponse;
import com.clerk.backend_api.models.operations.GetOrganizationRequest;
import com.clerk.backend_api.models.operations.GetOrganizationRequestBuilder;
import com.clerk.backend_api.models.operations.GetOrganizationResponse;
import com.clerk.backend_api.models.operations.ListOrganizationsRequest;
import com.clerk.backend_api.models.operations.ListOrganizationsRequestBuilder;
import com.clerk.backend_api.models.operations.ListOrganizationsResponse;
import com.clerk.backend_api.models.operations.MergeOrganizationMetadataRequest;
import com.clerk.backend_api.models.operations.MergeOrganizationMetadataRequestBody;
import com.clerk.backend_api.models.operations.MergeOrganizationMetadataRequestBuilder;
import com.clerk.backend_api.models.operations.MergeOrganizationMetadataResponse;
import com.clerk.backend_api.models.operations.UpdateOrganizationRequest;
import com.clerk.backend_api.models.operations.UpdateOrganizationRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateOrganizationResponse;
import com.clerk.backend_api.models.operations.UploadOrganizationLogoRequest;
import com.clerk.backend_api.models.operations.UploadOrganizationLogoRequestBody;
import com.clerk.backend_api.models.operations.UploadOrganizationLogoRequestBuilder;
import com.clerk.backend_api.models.operations.UploadOrganizationLogoResponse;
import com.clerk.backend_api.operations.CreateOrganization;
import com.clerk.backend_api.operations.DeleteOrganization;
import com.clerk.backend_api.operations.DeleteOrganizationLogo;
import com.clerk.backend_api.operations.GetOrganization;
import com.clerk.backend_api.operations.GetOrganizationBillingSubscription;
import com.clerk.backend_api.operations.ListOrganizations;
import com.clerk.backend_api.operations.MergeOrganizationMetadata;
import com.clerk.backend_api.operations.UpdateOrganization;
import com.clerk.backend_api.operations.UploadOrganizationLogo;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class Organizations {
    private final SDKConfiguration sdkConfiguration;

    Organizations(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListOrganizationsRequestBuilder list() {
        return new ListOrganizationsRequestBuilder(this.sdkConfiguration);
    }

    public ListOrganizationsResponse list(ListOrganizationsRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    public ListOrganizationsResponse list(ListOrganizationsRequest request, Optional<Options> options) throws Exception {
        ListOrganizations.Sync operation = new ListOrganizations.Sync(this.sdkConfiguration, options);
        return (ListOrganizationsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateOrganizationRequestBuilder create() {
        return new CreateOrganizationRequestBuilder(this.sdkConfiguration);
    }

    public CreateOrganizationResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateOrganizationResponse create(Optional<? extends CreateOrganizationRequestBody> request, Optional<Options> options) throws Exception {
        CreateOrganization.Sync operation = new CreateOrganization.Sync(this.sdkConfiguration, options);
        return (CreateOrganizationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetOrganizationRequestBuilder get() {
        return new GetOrganizationRequestBuilder(this.sdkConfiguration);
    }

    public GetOrganizationResponse get(String organizationId) throws Exception {
        return this.get(organizationId, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public GetOrganizationResponse get(String organizationId, Optional<Boolean> includeMembersCount, Optional<Boolean> includeMissingMemberWithElevatedPermissions, Optional<Options> options) throws Exception {
        GetOrganizationRequest request = GetOrganizationRequest.builder().organizationId(organizationId).includeMembersCount(includeMembersCount).includeMissingMemberWithElevatedPermissions(includeMissingMemberWithElevatedPermissions).build();
        GetOrganization.Sync operation = new GetOrganization.Sync(this.sdkConfiguration, options);
        return (GetOrganizationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateOrganizationRequestBuilder update() {
        return new UpdateOrganizationRequestBuilder(this.sdkConfiguration);
    }

    public UpdateOrganizationResponse update(String organizationId, UpdateOrganizationRequestBody requestBody) throws Exception {
        return this.update(organizationId, requestBody, Optional.empty());
    }

    public UpdateOrganizationResponse update(String organizationId, UpdateOrganizationRequestBody requestBody, Optional<Options> options) throws Exception {
        UpdateOrganizationRequest request = UpdateOrganizationRequest.builder().organizationId(organizationId).requestBody(requestBody).build();
        UpdateOrganization.Sync operation = new UpdateOrganization.Sync(this.sdkConfiguration, options);
        return (UpdateOrganizationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteOrganizationRequestBuilder delete() {
        return new DeleteOrganizationRequestBuilder(this.sdkConfiguration);
    }

    public DeleteOrganizationResponse delete(String organizationId) throws Exception {
        return this.delete(organizationId, Optional.empty());
    }

    public DeleteOrganizationResponse delete(String organizationId, Optional<Options> options) throws Exception {
        DeleteOrganizationRequest request = DeleteOrganizationRequest.builder().organizationId(organizationId).build();
        DeleteOrganization.Sync operation = new DeleteOrganization.Sync(this.sdkConfiguration, options);
        return (DeleteOrganizationResponse)operation.handleResponse(operation.doRequest(request));
    }

    public MergeOrganizationMetadataRequestBuilder mergeMetadata() {
        return new MergeOrganizationMetadataRequestBuilder(this.sdkConfiguration);
    }

    public MergeOrganizationMetadataResponse mergeMetadata(String organizationId, MergeOrganizationMetadataRequestBody requestBody) throws Exception {
        return this.mergeMetadata(organizationId, requestBody, Optional.empty());
    }

    public MergeOrganizationMetadataResponse mergeMetadata(String organizationId, MergeOrganizationMetadataRequestBody requestBody, Optional<Options> options) throws Exception {
        MergeOrganizationMetadataRequest request = MergeOrganizationMetadataRequest.builder().organizationId(organizationId).requestBody(requestBody).build();
        MergeOrganizationMetadata.Sync operation = new MergeOrganizationMetadata.Sync(this.sdkConfiguration, options);
        return (MergeOrganizationMetadataResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UploadOrganizationLogoRequestBuilder uploadLogo() {
        return new UploadOrganizationLogoRequestBuilder(this.sdkConfiguration);
    }

    public UploadOrganizationLogoResponse uploadLogo(String organizationId) throws Exception {
        return this.uploadLogo(organizationId, Optional.empty(), Optional.empty());
    }

    public UploadOrganizationLogoResponse uploadLogo(String organizationId, Optional<? extends UploadOrganizationLogoRequestBody> requestBody, Optional<Options> options) throws Exception {
        UploadOrganizationLogoRequest request = UploadOrganizationLogoRequest.builder().organizationId(organizationId).requestBody(requestBody).build();
        UploadOrganizationLogo.Sync operation = new UploadOrganizationLogo.Sync(this.sdkConfiguration, options);
        return (UploadOrganizationLogoResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteOrganizationLogoRequestBuilder deleteLogo() {
        return new DeleteOrganizationLogoRequestBuilder(this.sdkConfiguration);
    }

    public DeleteOrganizationLogoResponse deleteLogo(String organizationId) throws Exception {
        return this.deleteLogo(organizationId, Optional.empty());
    }

    public DeleteOrganizationLogoResponse deleteLogo(String organizationId, Optional<Options> options) throws Exception {
        DeleteOrganizationLogoRequest request = DeleteOrganizationLogoRequest.builder().organizationId(organizationId).build();
        DeleteOrganizationLogo.Sync operation = new DeleteOrganizationLogo.Sync(this.sdkConfiguration, options);
        return (DeleteOrganizationLogoResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetOrganizationBillingSubscriptionRequestBuilder getBillingSubscription() {
        return new GetOrganizationBillingSubscriptionRequestBuilder(this.sdkConfiguration);
    }

    public GetOrganizationBillingSubscriptionResponse getBillingSubscription(String organizationId) throws Exception {
        return this.getBillingSubscription(organizationId, Optional.empty());
    }

    public GetOrganizationBillingSubscriptionResponse getBillingSubscription(String organizationId, Optional<Options> options) throws Exception {
        GetOrganizationBillingSubscriptionRequest request = GetOrganizationBillingSubscriptionRequest.builder().organizationId(organizationId).build();
        GetOrganizationBillingSubscription.Sync operation = new GetOrganizationBillingSubscription.Sync(this.sdkConfiguration, options);
        return (GetOrganizationBillingSubscriptionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

