/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreatePhoneNumberRequestBody;
import com.clerk.backend_api.models.operations.CreatePhoneNumberRequestBuilder;
import com.clerk.backend_api.models.operations.CreatePhoneNumberResponse;
import com.clerk.backend_api.models.operations.DeletePhoneNumberRequest;
import com.clerk.backend_api.models.operations.DeletePhoneNumberRequestBuilder;
import com.clerk.backend_api.models.operations.DeletePhoneNumberResponse;
import com.clerk.backend_api.models.operations.GetPhoneNumberRequest;
import com.clerk.backend_api.models.operations.GetPhoneNumberRequestBuilder;
import com.clerk.backend_api.models.operations.GetPhoneNumberResponse;
import com.clerk.backend_api.models.operations.UpdatePhoneNumberRequest;
import com.clerk.backend_api.models.operations.UpdatePhoneNumberRequestBody;
import com.clerk.backend_api.models.operations.UpdatePhoneNumberRequestBuilder;
import com.clerk.backend_api.models.operations.UpdatePhoneNumberResponse;
import com.clerk.backend_api.operations.CreatePhoneNumber;
import com.clerk.backend_api.operations.DeletePhoneNumber;
import com.clerk.backend_api.operations.GetPhoneNumber;
import com.clerk.backend_api.operations.UpdatePhoneNumber;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class PhoneNumbers {
    private final SDKConfiguration sdkConfiguration;

    PhoneNumbers(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreatePhoneNumberRequestBuilder create() {
        return new CreatePhoneNumberRequestBuilder(this.sdkConfiguration);
    }

    public CreatePhoneNumberResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreatePhoneNumberResponse create(Optional<? extends CreatePhoneNumberRequestBody> request, Optional<Options> options) throws Exception {
        CreatePhoneNumber.Sync operation = new CreatePhoneNumber.Sync(this.sdkConfiguration, options);
        return (CreatePhoneNumberResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetPhoneNumberRequestBuilder get() {
        return new GetPhoneNumberRequestBuilder(this.sdkConfiguration);
    }

    public GetPhoneNumberResponse get(String phoneNumberId) throws Exception {
        return this.get(phoneNumberId, Optional.empty());
    }

    public GetPhoneNumberResponse get(String phoneNumberId, Optional<Options> options) throws Exception {
        GetPhoneNumberRequest request = GetPhoneNumberRequest.builder().phoneNumberId(phoneNumberId).build();
        GetPhoneNumber.Sync operation = new GetPhoneNumber.Sync(this.sdkConfiguration, options);
        return (GetPhoneNumberResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeletePhoneNumberRequestBuilder delete() {
        return new DeletePhoneNumberRequestBuilder(this.sdkConfiguration);
    }

    public DeletePhoneNumberResponse delete(String phoneNumberId) throws Exception {
        return this.delete(phoneNumberId, Optional.empty());
    }

    public DeletePhoneNumberResponse delete(String phoneNumberId, Optional<Options> options) throws Exception {
        DeletePhoneNumberRequest request = DeletePhoneNumberRequest.builder().phoneNumberId(phoneNumberId).build();
        DeletePhoneNumber.Sync operation = new DeletePhoneNumber.Sync(this.sdkConfiguration, options);
        return (DeletePhoneNumberResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdatePhoneNumberRequestBuilder update() {
        return new UpdatePhoneNumberRequestBuilder(this.sdkConfiguration);
    }

    public UpdatePhoneNumberResponse update(String phoneNumberId) throws Exception {
        return this.update(phoneNumberId, Optional.empty(), Optional.empty());
    }

    public UpdatePhoneNumberResponse update(String phoneNumberId, Optional<? extends UpdatePhoneNumberRequestBody> requestBody, Optional<Options> options) throws Exception {
        UpdatePhoneNumberRequest request = UpdatePhoneNumberRequest.builder().phoneNumberId(phoneNumberId).requestBody(requestBody).build();
        UpdatePhoneNumber.Sync operation = new UpdatePhoneNumber.Sync(this.sdkConfiguration, options);
        return (UpdatePhoneNumberResponse)operation.handleResponse(operation.doRequest(request));
    }
}

