/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.hooks.SDKHooks;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.Hooks;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.SpeakeasyHTTPClient;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class SDKConfiguration {
    private static final String LANGUAGE = "java";
    public static final String OPENAPI_DOC_VERSION = "2025-04-10";
    public static final String SDK_VERSION = "3.2.0";
    public static final String GEN_VERSION = "2.687.13";
    private static final String BASE_PACKAGE = "com.clerk.backend_api";
    public static final String USER_AGENT = String.format("speakeasy-sdk/%s %s %s %s %s", "java", "3.2.0", "2.687.13", "2025-04-10", "com.clerk.backend_api");
    private SecuritySource securitySource = SecuritySource.of(null);
    private HTTPClient client = new SpeakeasyHTTPClient();
    private String serverUrl;
    private int serverIdx = 0;
    private Hooks _hooks = SDKConfiguration.createHooks();
    private Optional<RetryConfig> retryConfig = Optional.empty();

    public SecuritySource securitySource() {
        return this.securitySource;
    }

    public void setSecuritySource(SecuritySource securitySource) {
        Utils.checkNotNull(securitySource, "securitySource");
        this.securitySource = securitySource;
    }

    public HTTPClient client() {
        return this.client;
    }

    public void setClient(HTTPClient client) {
        Utils.checkNotNull(client, "client");
        this.client = client;
    }

    public String serverUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        Utils.checkNotNull(serverUrl, "serverUrl");
        this.serverUrl = SDKConfiguration.trimFinalSlash(serverUrl);
    }

    private static String trimFinalSlash(String url) {
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String resolvedServerUrl() {
        return this.serverUrl;
    }

    public void setServerIdx(int serverIdx) {
        this.serverIdx = serverIdx;
    }

    public int serverIdx() {
        return this.serverIdx;
    }

    private static Hooks createHooks() {
        Hooks hooks = new Hooks();
        return hooks;
    }

    public Hooks hooks() {
        return this._hooks;
    }

    public void setHooks(Hooks hooks) {
        this._hooks = hooks;
    }

    public void initialize() {
        SDKHooks.initialize(this._hooks);
    }

    public Optional<RetryConfig> retryConfig() {
        return this.retryConfig;
    }

    public void setRetryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
    }
}

