/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateSAMLConnectionRequestBody;
import com.clerk.backend_api.models.operations.CreateSAMLConnectionRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSAMLConnectionResponse;
import com.clerk.backend_api.models.operations.DeleteSAMLConnectionRequest;
import com.clerk.backend_api.models.operations.DeleteSAMLConnectionRequestBuilder;
import com.clerk.backend_api.models.operations.DeleteSAMLConnectionResponse;
import com.clerk.backend_api.models.operations.GetSAMLConnectionRequest;
import com.clerk.backend_api.models.operations.GetSAMLConnectionRequestBuilder;
import com.clerk.backend_api.models.operations.GetSAMLConnectionResponse;
import com.clerk.backend_api.models.operations.ListSAMLConnectionsRequest;
import com.clerk.backend_api.models.operations.ListSAMLConnectionsRequestBuilder;
import com.clerk.backend_api.models.operations.ListSAMLConnectionsResponse;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionRequest;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionRequestBody;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionRequestBuilder;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionResponse;
import com.clerk.backend_api.operations.CreateSAMLConnection;
import com.clerk.backend_api.operations.DeleteSAMLConnection;
import com.clerk.backend_api.operations.GetSAMLConnection;
import com.clerk.backend_api.operations.ListSAMLConnections;
import com.clerk.backend_api.operations.UpdateSAMLConnection;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class SamlConnections {
    private final SDKConfiguration sdkConfiguration;

    SamlConnections(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListSAMLConnectionsRequestBuilder list() {
        return new ListSAMLConnectionsRequestBuilder(this.sdkConfiguration);
    }

    public ListSAMLConnectionsResponse list(ListSAMLConnectionsRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    public ListSAMLConnectionsResponse list(ListSAMLConnectionsRequest request, Optional<Options> options) throws Exception {
        ListSAMLConnections.Sync operation = new ListSAMLConnections.Sync(this.sdkConfiguration, options);
        return (ListSAMLConnectionsResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateSAMLConnectionRequestBuilder create() {
        return new CreateSAMLConnectionRequestBuilder(this.sdkConfiguration);
    }

    public CreateSAMLConnectionResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateSAMLConnectionResponse create(Optional<? extends CreateSAMLConnectionRequestBody> request, Optional<Options> options) throws Exception {
        CreateSAMLConnection.Sync operation = new CreateSAMLConnection.Sync(this.sdkConfiguration, options);
        return (CreateSAMLConnectionResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetSAMLConnectionRequestBuilder get() {
        return new GetSAMLConnectionRequestBuilder(this.sdkConfiguration);
    }

    public GetSAMLConnectionResponse get(String samlConnectionId) throws Exception {
        return this.get(samlConnectionId, Optional.empty());
    }

    public GetSAMLConnectionResponse get(String samlConnectionId, Optional<Options> options) throws Exception {
        GetSAMLConnectionRequest request = GetSAMLConnectionRequest.builder().samlConnectionId(samlConnectionId).build();
        GetSAMLConnection.Sync operation = new GetSAMLConnection.Sync(this.sdkConfiguration, options);
        return (GetSAMLConnectionResponse)operation.handleResponse(operation.doRequest(request));
    }

    public UpdateSAMLConnectionRequestBuilder update() {
        return new UpdateSAMLConnectionRequestBuilder(this.sdkConfiguration);
    }

    public UpdateSAMLConnectionResponse update(String samlConnectionId, UpdateSAMLConnectionRequestBody requestBody) throws Exception {
        return this.update(samlConnectionId, requestBody, Optional.empty());
    }

    public UpdateSAMLConnectionResponse update(String samlConnectionId, UpdateSAMLConnectionRequestBody requestBody, Optional<Options> options) throws Exception {
        UpdateSAMLConnectionRequest request = UpdateSAMLConnectionRequest.builder().samlConnectionId(samlConnectionId).requestBody(requestBody).build();
        UpdateSAMLConnection.Sync operation = new UpdateSAMLConnection.Sync(this.sdkConfiguration, options);
        return (UpdateSAMLConnectionResponse)operation.handleResponse(operation.doRequest(request));
    }

    public DeleteSAMLConnectionRequestBuilder delete() {
        return new DeleteSAMLConnectionRequestBuilder(this.sdkConfiguration);
    }

    public DeleteSAMLConnectionResponse delete(String samlConnectionId) throws Exception {
        return this.delete(samlConnectionId, Optional.empty());
    }

    public DeleteSAMLConnectionResponse delete(String samlConnectionId, Optional<Options> options) throws Exception {
        DeleteSAMLConnectionRequest request = DeleteSAMLConnectionRequest.builder().samlConnectionId(samlConnectionId).build();
        DeleteSAMLConnection.Sync operation = new DeleteSAMLConnection.Sync(this.sdkConfiguration, options);
        return (DeleteSAMLConnectionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

