/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateSessionRequestBody;
import com.clerk.backend_api.models.operations.CreateSessionRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSessionResponse;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateRequest;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateRequestBody;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateResponse;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequest;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequestBody;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequestBuilder;
import com.clerk.backend_api.models.operations.CreateSessionTokenResponse;
import com.clerk.backend_api.models.operations.GetSessionListRequest;
import com.clerk.backend_api.models.operations.GetSessionListRequestBuilder;
import com.clerk.backend_api.models.operations.GetSessionListResponse;
import com.clerk.backend_api.models.operations.GetSessionRequest;
import com.clerk.backend_api.models.operations.GetSessionRequestBuilder;
import com.clerk.backend_api.models.operations.GetSessionResponse;
import com.clerk.backend_api.models.operations.RefreshSessionRequest;
import com.clerk.backend_api.models.operations.RefreshSessionRequestBody;
import com.clerk.backend_api.models.operations.RefreshSessionRequestBuilder;
import com.clerk.backend_api.models.operations.RefreshSessionResponse;
import com.clerk.backend_api.models.operations.RevokeSessionRequest;
import com.clerk.backend_api.models.operations.RevokeSessionRequestBuilder;
import com.clerk.backend_api.models.operations.RevokeSessionResponse;
import com.clerk.backend_api.operations.CreateSession;
import com.clerk.backend_api.operations.CreateSessionToken;
import com.clerk.backend_api.operations.CreateSessionTokenFromTemplate;
import com.clerk.backend_api.operations.GetSession;
import com.clerk.backend_api.operations.GetSessionList;
import com.clerk.backend_api.operations.RefreshSession;
import com.clerk.backend_api.operations.RevokeSession;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class Sessions {
    private final SDKConfiguration sdkConfiguration;

    Sessions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public GetSessionListRequestBuilder list() {
        return new GetSessionListRequestBuilder(this.sdkConfiguration);
    }

    public GetSessionListResponse list(GetSessionListRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    public GetSessionListResponse list(GetSessionListRequest request, Optional<Options> options) throws Exception {
        GetSessionList.Sync operation = new GetSessionList.Sync(this.sdkConfiguration, options);
        return (GetSessionListResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateSessionRequestBuilder create() {
        return new CreateSessionRequestBuilder(this.sdkConfiguration);
    }

    public CreateSessionResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateSessionResponse create(Optional<? extends CreateSessionRequestBody> request, Optional<Options> options) throws Exception {
        CreateSession.Sync operation = new CreateSession.Sync(this.sdkConfiguration, options);
        return (CreateSessionResponse)operation.handleResponse(operation.doRequest(request));
    }

    public GetSessionRequestBuilder get() {
        return new GetSessionRequestBuilder(this.sdkConfiguration);
    }

    public GetSessionResponse get(String sessionId) throws Exception {
        return this.get(sessionId, Optional.empty());
    }

    public GetSessionResponse get(String sessionId, Optional<Options> options) throws Exception {
        GetSessionRequest request = GetSessionRequest.builder().sessionId(sessionId).build();
        GetSession.Sync operation = new GetSession.Sync(this.sdkConfiguration, options);
        return (GetSessionResponse)operation.handleResponse(operation.doRequest(request));
    }

    public RefreshSessionRequestBuilder refresh() {
        return new RefreshSessionRequestBuilder(this.sdkConfiguration);
    }

    public RefreshSessionResponse refresh(String sessionId) throws Exception {
        return this.refresh(sessionId, Optional.empty(), Optional.empty());
    }

    public RefreshSessionResponse refresh(String sessionId, Optional<? extends RefreshSessionRequestBody> requestBody, Optional<Options> options) throws Exception {
        RefreshSessionRequest request = RefreshSessionRequest.builder().sessionId(sessionId).requestBody(requestBody).build();
        RefreshSession.Sync operation = new RefreshSession.Sync(this.sdkConfiguration, options);
        return (RefreshSessionResponse)operation.handleResponse(operation.doRequest(request));
    }

    public RevokeSessionRequestBuilder revoke() {
        return new RevokeSessionRequestBuilder(this.sdkConfiguration);
    }

    public RevokeSessionResponse revoke(String sessionId) throws Exception {
        return this.revoke(sessionId, Optional.empty());
    }

    public RevokeSessionResponse revoke(String sessionId, Optional<Options> options) throws Exception {
        RevokeSessionRequest request = RevokeSessionRequest.builder().sessionId(sessionId).build();
        RevokeSession.Sync operation = new RevokeSession.Sync(this.sdkConfiguration, options);
        return (RevokeSessionResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateSessionTokenRequestBuilder createToken() {
        return new CreateSessionTokenRequestBuilder(this.sdkConfiguration);
    }

    public CreateSessionTokenResponse createToken(String sessionId) throws Exception {
        return this.createToken(sessionId, Optional.empty(), Optional.empty());
    }

    public CreateSessionTokenResponse createToken(String sessionId, Optional<? extends CreateSessionTokenRequestBody> requestBody, Optional<Options> options) throws Exception {
        CreateSessionTokenRequest request = CreateSessionTokenRequest.builder().sessionId(sessionId).requestBody(requestBody).build();
        CreateSessionToken.Sync operation = new CreateSessionToken.Sync(this.sdkConfiguration, options);
        return (CreateSessionTokenResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateSessionTokenFromTemplateRequestBuilder createTokenFromTemplate() {
        return new CreateSessionTokenFromTemplateRequestBuilder(this.sdkConfiguration);
    }

    public CreateSessionTokenFromTemplateResponse createTokenFromTemplate(String sessionId, String templateName) throws Exception {
        return this.createTokenFromTemplate(sessionId, templateName, Optional.empty(), Optional.empty());
    }

    public CreateSessionTokenFromTemplateResponse createTokenFromTemplate(String sessionId, String templateName, Optional<? extends CreateSessionTokenFromTemplateRequestBody> requestBody, Optional<Options> options) throws Exception {
        CreateSessionTokenFromTemplateRequest request = CreateSessionTokenFromTemplateRequest.builder().sessionId(sessionId).templateName(templateName).requestBody(requestBody).build();
        CreateSessionTokenFromTemplate.Sync operation = new CreateSessionTokenFromTemplate.Sync(this.sdkConfiguration, options);
        return (CreateSessionTokenFromTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }
}

