/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateWaitlistEntryRequestBody;
import com.clerk.backend_api.models.operations.CreateWaitlistEntryRequestBuilder;
import com.clerk.backend_api.models.operations.CreateWaitlistEntryResponse;
import com.clerk.backend_api.models.operations.InviteWaitlistEntryRequest;
import com.clerk.backend_api.models.operations.InviteWaitlistEntryRequestBody;
import com.clerk.backend_api.models.operations.InviteWaitlistEntryRequestBuilder;
import com.clerk.backend_api.models.operations.InviteWaitlistEntryResponse;
import com.clerk.backend_api.models.operations.ListWaitlistEntriesRequest;
import com.clerk.backend_api.models.operations.ListWaitlistEntriesRequestBuilder;
import com.clerk.backend_api.models.operations.ListWaitlistEntriesResponse;
import com.clerk.backend_api.models.operations.RejectWaitlistEntryRequest;
import com.clerk.backend_api.models.operations.RejectWaitlistEntryRequestBuilder;
import com.clerk.backend_api.models.operations.RejectWaitlistEntryResponse;
import com.clerk.backend_api.operations.CreateWaitlistEntry;
import com.clerk.backend_api.operations.InviteWaitlistEntry;
import com.clerk.backend_api.operations.ListWaitlistEntries;
import com.clerk.backend_api.operations.RejectWaitlistEntry;
import com.clerk.backend_api.utils.Options;
import java.util.Optional;

public class WaitlistEntries {
    private final SDKConfiguration sdkConfiguration;

    WaitlistEntries(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListWaitlistEntriesRequestBuilder list() {
        return new ListWaitlistEntriesRequestBuilder(this.sdkConfiguration);
    }

    public ListWaitlistEntriesResponse list(ListWaitlistEntriesRequest request) throws Exception {
        return this.list(request, Optional.empty());
    }

    public ListWaitlistEntriesResponse list(ListWaitlistEntriesRequest request, Optional<Options> options) throws Exception {
        ListWaitlistEntries.Sync operation = new ListWaitlistEntries.Sync(this.sdkConfiguration, options);
        return (ListWaitlistEntriesResponse)operation.handleResponse(operation.doRequest(request));
    }

    public CreateWaitlistEntryRequestBuilder create() {
        return new CreateWaitlistEntryRequestBuilder(this.sdkConfiguration);
    }

    public CreateWaitlistEntryResponse createDirect() throws Exception {
        return this.create(Optional.empty(), Optional.empty());
    }

    public CreateWaitlistEntryResponse create(Optional<? extends CreateWaitlistEntryRequestBody> request, Optional<Options> options) throws Exception {
        CreateWaitlistEntry.Sync operation = new CreateWaitlistEntry.Sync(this.sdkConfiguration, options);
        return (CreateWaitlistEntryResponse)operation.handleResponse(operation.doRequest(request));
    }

    public InviteWaitlistEntryRequestBuilder invite() {
        return new InviteWaitlistEntryRequestBuilder(this.sdkConfiguration);
    }

    public InviteWaitlistEntryResponse invite(String waitlistEntryId) throws Exception {
        return this.invite(waitlistEntryId, Optional.empty(), Optional.empty());
    }

    public InviteWaitlistEntryResponse invite(String waitlistEntryId, Optional<? extends InviteWaitlistEntryRequestBody> requestBody, Optional<Options> options) throws Exception {
        InviteWaitlistEntryRequest request = InviteWaitlistEntryRequest.builder().waitlistEntryId(waitlistEntryId).requestBody(requestBody).build();
        InviteWaitlistEntry.Sync operation = new InviteWaitlistEntry.Sync(this.sdkConfiguration, options);
        return (InviteWaitlistEntryResponse)operation.handleResponse(operation.doRequest(request));
    }

    public RejectWaitlistEntryRequestBuilder reject() {
        return new RejectWaitlistEntryRequestBuilder(this.sdkConfiguration);
    }

    public RejectWaitlistEntryResponse reject(String waitlistEntryId) throws Exception {
        return this.reject(waitlistEntryId, Optional.empty());
    }

    public RejectWaitlistEntryResponse reject(String waitlistEntryId, Optional<Options> options) throws Exception {
        RejectWaitlistEntryRequest request = RejectWaitlistEntryRequest.builder().waitlistEntryId(waitlistEntryId).build();
        RejectWaitlistEntry.Sync operation = new RejectWaitlistEntry.Sync(this.sdkConfiguration, options);
        return (RejectWaitlistEntryResponse)operation.handleResponse(operation.doRequest(request));
    }
}

