/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.helpers.security;

import com.clerk.backend_api.helpers.security.VerifyToken;
import com.clerk.backend_api.helpers.security.models.AuthErrorReason;
import com.clerk.backend_api.helpers.security.models.AuthenticateRequestOptions;
import com.clerk.backend_api.helpers.security.models.RequestState;
import com.clerk.backend_api.helpers.security.models.TokenType;
import com.clerk.backend_api.helpers.security.models.TokenVerificationException;
import com.clerk.backend_api.helpers.security.models.TokenVerificationResponse;
import com.clerk.backend_api.helpers.security.models.VerifyTokenOptions;
import com.clerk.backend_api.helpers.security.util.TokenTypeHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class AuthenticateRequest {
    private static final String SESSION_COOKIE_NAME = "__session";

    private AuthenticateRequest() {
    }

    public static RequestState authenticateRequest(Map<String, List<String>> requestHeaders, AuthenticateRequestOptions options) {
        TokenType tokenType;
        String sessionToken = AuthenticateRequest.getSessionToken(requestHeaders);
        if (sessionToken == null) {
            return RequestState.signedOut(AuthErrorReason.SESSION_TOKEN_MISSING);
        }
        List<String> acceptsTokens = options.acceptsToken();
        if (!acceptsTokens.contains((tokenType = TokenTypeHelper.getTokenType(sessionToken)).getType()) && !acceptsTokens.contains("any")) {
            return RequestState.signedOut(AuthErrorReason.TOKEN_TYPE_NOT_SUPPORTED);
        }
        VerifyTokenOptions verifyTokenOptions = AuthenticateRequest.buildVerifyTokenOptions(options);
        try {
            TokenVerificationResponse<?> tokenVerificationResponse = VerifyToken.verifyToken(sessionToken, verifyTokenOptions);
            return RequestState.signedIn(sessionToken, tokenVerificationResponse);
        }
        catch (TokenVerificationException e) {
            return RequestState.signedOut(e.reason());
        }
        catch (IOException | InterruptedException e) {
            return RequestState.signedOut(AuthErrorReason.INTERNAL_ERROR);
        }
    }

    private static String getSessionToken(Map<String, List<String>> requestHeaders) {
        Map lowerCaseHeaders = requestHeaders.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(((String)e.getKey()).toLowerCase(), (List)e.getValue()), HashMap::putAll);
        List authHeaders = (List)lowerCaseHeaders.get("authorization");
        if (authHeaders != null && !authHeaders.isEmpty()) {
            String bearerToken = (String)authHeaders.get(0);
            return bearerToken.replace("Bearer ", "");
        }
        List cookieHeaders = (List)lowerCaseHeaders.get("cookie");
        if (cookieHeaders == null || cookieHeaders.isEmpty()) {
            return null;
        }
        return Arrays.stream(((String)cookieHeaders.get(0)).split(";")).map(String::trim).map(s -> s.split("=", 2)).filter(kv -> kv[0].startsWith(SESSION_COOKIE_NAME)).map(kv -> kv[1]).findFirst().orElse(null);
    }

    private static VerifyTokenOptions buildVerifyTokenOptions(AuthenticateRequestOptions options) {
        if (options.jwtKey().isPresent()) {
            return VerifyTokenOptions.jwtKey(options.jwtKey().get()).audience(options.audience()).authorizedParties(options.authorizedParties()).clockSkew(options.clockSkewInMs(), TimeUnit.MILLISECONDS).build();
        }
        if (options.secretKey().isPresent()) {
            return VerifyTokenOptions.secretKey(options.secretKey().get()).audience(options.audience()).authorizedParties(options.authorizedParties()).clockSkew(options.clockSkewInMs(), TimeUnit.MILLISECONDS).build();
        }
        return new VerifyTokenOptions.Builder().build();
    }
}

